from torch.optim import SGD, Adam

def initialize_optimizer(config, model):
    # initialize optimizers
    if config.optimizer=='SGD':
        params = filter(lambda p: p.requires_grad, model.parameters())
        optimizer = SGD(
            params,
            lr=config.lr,
            weight_decay=config.weight_decay,
            **config.optimizer_kwargs)
    elif config.optimizer == 'Adam':
        params = filter(lambda p: p.requires_grad, model.parameters())
        optimizer = Adam(
            params,
            lr=config.lr,
            weight_decay=config.weight_decay,
            **config.optimizer_kwargs)
    else:
        raise ValueError(f'Optimizer {config.optimizer} not recognized.')
    if config.lars:
        print("=> use LARS optimizer.")
        from models.larc import LARC
        optimizer = LARC(optimizer=optimizer, trust_coefficient=.001, clip=False)
    return optimizer
