algorithm_defaults = {
    'ERM': {
        'train_loader': 'standard',
        'uniform_over_groups': False,
        'eval_loader': 'standard',
        'lars': False,
    },
    'groupDRO': {
        'train_loader': 'standard',
        'uniform_over_groups': True,
        'distinct_groups': True,
        'eval_loader': 'standard',
        'group_dro_step_size': 0.01,
        'lars': False,
    },
    'simsiam': {
        'train_loader': 'standard',
        'uniform_over_groups': False,
        'eval_loader': 'standard',
        'model_aug': False,
        'prune_perc': 0,
        'prune_method': 'global',
        'prune_criterion': 'magnitude',
        'prune_inc_perc': 0.5, # x1.5 pruning for next layer
        'prune_layer_th': 6,
        'reinit_method': 'threshold',
        'reinit_layer_th': 6,
        'weight_decay': 1.0e-3,
        'feat-dim': 2048,
        # 'schedule': [],
    },
    'simclr': {
        'train_loader': 'standard',
        'uniform_over_groups': False,
        'eval_loader': 'standard',
        'model_aug': False,
        'prune_perc': 0,
        'prune_method': 'global',
        'prune_criterion': 'magnitude',
        'prune_inc_perc': 0.5, # x1.5 pruning for next layer
        'prune_layer_th': 6,
        'reinit_method': 'threshold',
        'reinit_layer_th': 6,
        'temprature': 1.,
        'weight_decay': 1.0e-6,
        'feat-dim': 128,
        'temperature': 0.5, 
    },
}
