dataset_defaults = {
    'celebA': {
        'split_scheme': 'official',
        'model': 'resnet50',
        'original_resolution': (178, 218),
        # 'transform': 'image_base',
        'transform': 'celebA',
        'transform_ssl': 'image_base_ssl',
        'normalize': ([0.485, 0.456, 0.406], [0.229, 0.224, 0.225]),
        'loss_function': 'cross_entropy',
        'groupby_fields': ['male', 'y'],
        'val_metric': 'acc_wg',
        'val_metric_decreasing': False,
        'optimizer': 'SGD',
        'optimizer_kwargs': {'momentum': 0.9},
        'scheduler': None,
        'batch_size': 64,
        'lr': 0.001,
        'weight_decay': 0.0,
        'n_epochs': 200,
        'algo_log_metric': 'accuracy',
        'process_outputs_function': 'multiclass_logits_to_pred',
        'extra_vals': ['test'],
    },
    'waterbirds': {
        'split_scheme': 'official',
        'model': 'resnet18',
        'arch': 'resnet18',
        # 'transform': 'image_resize_and_center_crop',
        'transform': 'waterbirds',
        'transform_ssl': 'image_base_ssl',
        'resize_scale': 256.0/224.0,
        'normalize': ([0.485, 0.456, 0.406], [0.229, 0.224, 0.225]),
        # 'model_kwargs': {'pretrained': True},
        'loss_function': 'cross_entropy',
        'groupby_fields': ['background', 'y'],
        'val_metric': 'acc_wg',
        'val_metric_decreasing': False,
        'algo_log_metric': 'accuracy',
        'optimizer': 'SGD',
        'optimizer_kwargs': {'momentum':0.9},
        'scheduler': None,
        'batch_size': 32,
        'lr': 1e-5,
        # 'weight_decay': 1.0,
        'n_epochs': 800,
        'process_outputs_function': 'multiclass_logits_to_pred',
        'extra_vals': ['test'],
    },
    'cmnist': {
        'split_scheme': 'official',
        # 'model': 'mlp',
        'model': 'resnet18',
        'arch': 'resnet18',
        'original_resolution': (28, 28),
        'num_proj_layers': 2,
        'ssl_scale': (0.2, 1.),
        'normalize': ((0.1307, 0.1307, 0.), (0.3081, 0.3081, 0.3081)), 
        'transform': 'cmnist',
        # 'transform': 'image_base',
        'transform_ssl': 'image_base_ssl',
        'loss_function': 'cross_entropy',
        'groupby_fields': ['background', 'y'],
        'val_metric': 'acc_wg',
        'val_metric_decreasing': False,
        'algo_log_metric': 'accuracy',
        # 'optimizer': 'SGD',
        # 'optimizer_kwargs': {'momentum':0.9},
        'optimizer': 'Adam',
        'scheduler': None,
        'batch_size': 128,
        'lr': 1e-3,
        # 'weight_decay': 0.,
        'n_epochs': 10,
        'process_outputs_function': 'multiclass_logits_to_pred',
        'dataset_kwargs': {'invar_str': 1., 'spur_str': 0.99},
        'extra_vals': ['test'],
        # 'extra_vals': ['test', 'test_no_spur'],
    },
    'spur_cifar10': {
        'split_scheme': 'official',
        'model': 'cifar_resnet18',
        'original_resolution': (32, 32),
        'num_proj_layers': 2,
        # 'transform': 'image_base',
        'transform': 'cifar10',
        # 'lincls_transform': 'cifar10',
        # 'transform_kwargs': {'scale': (0.08, 1.), 'ratio': (3.0/4.0, 4.0/3.0)},
        'transform_scale': (0.2, 1.),
        # 'transform_ratio': (3.0/4.0, 4.0/3.0),
        'transform_ssl': 'image_base_ssl',
        'ssl_scale': (0.2, 1.),
        'normalize': ((0.4914, 0.4822, 0.4465), (0.2023, 0.1994, 0.2010)),
        'loss_function': 'cross_entropy',
        'groupby_fields': ['background', 'y'],
        'val_metric': 'acc_wg',
        'val_metric_decreasing': False,
        'algo_log_metric': 'accuracy',
        'optimizer': 'SGD',
        'optimizer_kwargs': {'momentum':0.9},
        'scheduler': None,
        # simsiam
        'batch_size': 128,
        'lr': 1e-4,
        # 'weight_decay': 1.0,
        'n_epochs': 300,
        'process_outputs_function': 'multiclass_logits_to_pred',
        # 'dataset_kwargs': {}
        'dataset_kwargs': {'invar_str': 1., 'spur_str': 0.95}, # default
        'extra_vals': ['test'],
        # 'extra_vals': ['test', 'test_no_spur'],
    },
    'metashift':  {
        'split_scheme': 'official',
        'normalize': ((0.485, 0.456, 0.406), (0.229, 0.224, 0.225)),
        'model': 'resnet18',
        'arch': 'resnet18',
        'original_resolution': (224, 224),
        'transform': 'image_base',
        'transform_ssl': 'image_base_ssl',
        'loss_function': 'cross_entropy',
        'groupby_fields': ['env', 'y'],
        'val_metric': 'acc_wg',
        'val_metric_decreasing': False,
        'optimizer': 'SGD',
        'optimizer_kwargs': {'momentum': 0.9},
        'scheduler': None,
        'batch_size': 32,
        'lr': 5e-4,
        'weight_decay': 0.0,
        'n_epochs': 200,
        'algo_log_metric': 'accuracy',
        'process_outputs_function': 'multiclass_logits_to_pred',
        'extra_vals': ['test'],
    },
    'cifar10': {
        'split_scheme': 'official',
        'model': 'resnet18',
        'original_resolution': (32, 32),
        'num_proj_layers': 2,
        'transform': 'cifar10',
        'transform_scale': (0.2, 1.),
        'transform_ssl': 'image_base_ssl',
        'ssl_scale': (0.2, 1.),
        'normalize': ((0.4914, 0.4822, 0.4465), (0.2023, 0.1994, 0.2010)),
        'loss_function': 'cross_entropy',
        'groupby_fields': ['y'],
        'val_metric': 'acc_avg',
        'val_metric_decreasing': False,
        'algo_log_metric': 'accuracy',
        'optimizer': 'SGD',
        'optimizer_kwargs': {'momentum':0.9},
        'scheduler': None,
        # simsiam
        'batch_size': 512,
        'lr': 0.06,
        'weight_decay': 5e-4,
        'n_epochs': 800,
        'process_outputs_function': 'multiclass_logits_to_pred',
        'eval_set': 'test',
        'extra_vals': [],
    },
    'hard_imagenet': {
        'split_scheme': 'official',
        'normalize': ((0.485, 0.456, 0.406), (0.229, 0.224, 0.225)),
        'model': 'resnet50',
        'original_resolution': (224, 224),
        'transform': 'image_base',
        'transform_ssl': 'image_base_ssl',
        'loss_function': 'cross_entropy',
        'groupby_fields': ['g'],
        'val_metric': 'acc',
        'val_metric_decreasing': False,
        'optimizer': 'SGD',
        'optimizer_kwargs': {'momentum': 0.9},
        'scheduler': None,
        'batch_size': 256,
        'lr': 5e-4,
        'weight_decay': 0.0,
        'n_epochs': 200,
        'algo_log_metric': 'accuracy',
        'process_outputs_function': 'multiclass_logits_to_pred',
        'extra_vals': ['test', 'tile_test', 'replace_with_gray_test', 'replace_bbox_with_gray_test'],
        # 'tile_test' 'test'
    },
    'bgchallenge': {
        'split_scheme': 'official',
        'normalize': ((0.485, 0.456, 0.406), (0.229, 0.224, 0.225)),
        'model': 'resnet50',
        'original_resolution': (224, 224),
        'transform': 'image_base',
        'transform_ssl': 'image_base_ssl',
        'loss_function': 'cross_entropy',
        'groupby_fields': ['g'],
        'val_metric': 'acc',
        'val_metric_decreasing': False,
        'optimizer': 'SGD',
        'optimizer_kwargs': {'momentum': 0.9},
        'scheduler': None,
        'batch_size': 256,
        'lr': 5e-4,
        'weight_decay': 0.0,
        'n_epochs': 200,
        'algo_log_metric': 'accuracy',
        'process_outputs_function': 'multiclass_logits_to_pred',
        'extra_vals': ['test', 'only_fg', 'no_fg', 'paintings_bg'],
    },
    'imagenet': {
       'split_scheme': 'official',
        'normalize': ((0.485, 0.456, 0.406), (0.229, 0.224, 0.225)),
        'model': 'resnet50',
        'original_resolution': (224, 224),
        'transform': 'image_base',
        'transform_ssl': 'image_base_ssl',
        'loss_function': 'cross_entropy',
        'groupby_fields': ['y'],
        'val_metric': 'acc_avg',
        'val_metric_decreasing': False,
        'algo_log_metric': 'accuracy',
        'optimizer': 'SGD',
        'optimizer_kwargs': {'momentum':0.9},
        'scheduler': None,
        # simsiam
        'batch_size': 512,
        'lr': 0.06,
        # 'weight_decay': 5e-4,
        'n_epochs': 800,
        'process_outputs_function': 'multiclass_logits_to_pred',
        'eval_set': 'test',
        'extra_vals': [],
    },
    'cxr': {
        'split_scheme': 'official',
        'normalize': ((0.485, 0.456, 0.406), (0.229, 0.224, 0.225)),
        'model': 'resnet50',
        # 'model': 'densenet121',
        # 'arch': 'resnet50',
        'original_resolution': (224, 224),
        'transform': 'image_base',
        'transform_ssl': 'image_base_ssl',
        'eval-freq': 1,
        'loss_function': 'cross_entropy',
        'groupby_fields': ['a', 'y'],
        'val_metric': 'acc_wg',
        'val_metric_decreasing': False,
        'optimizer': 'SGD',
        'optimizer_kwargs': {'momentum': 0.9},
        'scheduler': None,
        'batch_size': 128,
        # 'lr': 0.01,
        # 'weight_decay': 1e-4,
        'lr': 5e-4,
        'weight_decay': 0.0,
        'n_epochs': 200,
        'algo_log_metric': 'accuracy',
        'process_outputs_function': 'multiclass_logits_to_pred',
        'extra_vals': ['test'],
        # 'extra_vals': ['test', 'only_fg', 'no_fg', 'paintings_bg'],
    }
}
