## Instructions for running Maze2D experiments 

### Download datasets
Download the dataset for Maze2D from http://rail.eecs.berkeley.edu/datasets/offline_rl/maze2d/.
You have to put maze2d-umaze-sparse-v1.hdf5 and maze2d-medium-sparse-v1.hdf5 under `data/`.

### Run Scripts
For experiments in Maze-O,
#### Ours
```bash
$ python custom/align.py
```

#### GAMA
```bash
$ python custom/dail.py
```

#### Cond
```bash
$ python custom/traj_training.py
```

The results will be displayed or saved in `custom/results/`.

### Options
For each command, you can add
- `--device` for specifying GPU.
- `--comet` is a flag of logging with Comet.
- `--name` for specifying run_name of comet
- `--env` for specifying maze shape.
    - Default: medium maze. Add `--env maze2d-umaze-v1` for the umaze.
- `--action inv` for experiments in Maze-OA.
- `--goal` for specifying the goal ID.
  - We used goals 1, 4, 7 for the umaze, 7, 18, 21 for the medium maze.
    These points are selected from different parts of the maze as much as possible.

For example, if you want to run an experiment in Maze-OA (umaze) with goal no. 7,
```bash
$ python custom/align.py --name test-ours --env maze2d-umaze-v1 --action inv --goal 7  
```
