from collections import defaultdict
from pathlib import Path

import numpy as np
import pandas as pd

results_dir = Path("results")
root_dirs_dict = defaultdict(list)
for root_dir in sorted(results_dir.glob("*")):
    stem = root_dir.stem.rsplit("_", 1)[0]
    root_dirs_dict[stem].append(root_dir)

for experiment_name, root_dirs in root_dirs_dict.items():
    success_rates = []
    for root_dir in root_dirs:
        if not root_dir.is_dir():
            continue
        for logdir in root_dir.glob("*"):
            if not logdir.is_dir():
                continue
            try:
                csv = pd.read_csv(logdir / "adapt_eval.csv")
                success_rates.append(csv["target_success_rate"].values)
            except:
                pass

    print(experiment_name)
    try:
        success_rates = np.stack(success_rates).T
        epochs = csv["epoch"]
        mean = np.mean(success_rates, axis=1)
        std = np.std(success_rates, axis=1)

        for i, m in enumerate(mean):
            print(f"Epoch {epochs[i]:02d}: {mean[i]:.3f} \pm {std[i]:.3f}")
        print()
    except:
        continue
