VisMoV3D <- function(Xmat, Ymat, MoVDens0, MoVDens1, title, zmax=0.007){
  N = length(MoVDens1)
  fig = plot_ly() %>%
      add_surface(x = Xmat,
                  y = Ymat,
                  z = MoVDens0,
                  opacity = 1,
                  colorscale = list(c(0, 1), c("blue", "blue"))
                  ) %>%
      add_surface(x = Xmat,
                  y = Ymat,
                  z = MoVDens1[[1]],
                  opacity = 0.7,
                  colorscale = list(c(0, 1), c("red", "red"))
      ) %>%
      add_surface(x = Xmat,
                  y = Ymat,
                  z = MoVDens1[[2]],
                  opacity = 0.7,
                  colorscale = list(c(0, 1), c("red", "red"))
      ) %>%
      add_surface(x = Xmat,
                  y = Ymat,
                  z = MoVDens1[[3]],
                  opacity = 0.7,
                  colorscale = list(c(0, 1), c("red", "red"))
      ) %>%
      add_surface(x = Xmat,
                  y = Ymat,
                  z = MoVDens1[[4]],
                  opacity = 0.7,
                  colorscale = list(c(0, 1), c("red", "red"))
      ) %>%
      add_surface(x = Xmat,
                  y = Ymat,
                  z = MoVDens1[[5]],
                  opacity = 0.7,
                  colorscale = list(c(0, 1), c("red", "red"))
      ) %>%
      layout(title = title,
             scene = list(xaxis = list(title = 'x'),
                          yaxis = list(title = 'y'),
                          zaxis = list(title = 'z', range = c(0,zmax))),
             updatemenus = list(
               list(
                 type = "buttons",
                 y = 0.8,
                 buttons = list(
                   list(method = "restyle",
                        args = list("visible", c(T,F,F,F,F,F)),
                        label = "Mean Density"),
                   
                   list(method = "restyle",
                        args = list("visible", c(T,T,F,F,F,F)),
                        label = "Alpha = -2"),
                   
                   list(method = "restyle",
                        args = list("visible", c(T,F,T,F,F,F)),
                        label = "alpha = -1"),
                   
                   list(method = "restyle",
                        args = list("visible", c(T,F,F,T,F,F)),
                        label = "alpha = 0"),
                   
                   list(method = "restyle",
                        args = list("visible", c(T,F,F,F,T,F)),
                        label = "alpha = 1"),
                   list(method = "restyle",
                        args = list("visible", c(T,F,F,F,F,T)),
                        label = "alpha = 2")
                   
                   
                 ))
             ))
  return(fig)
}

VisMoV2D <- function(Xvec, MoV.mu, MoV.kt, label=NULL,xlabel= "temperature range",ylabel="Density"){
  n = length(MoV.kt[[1]])
  if(is.null(label)){
    label = 1:n
  }
  plot.df = data.frame()
  
  for (l in 1:length(MoV.kt)){
    for(i in 1:n){
      plot.df = plot.df %>% rbind(data.frame(X = Xvec, 
                                             Y = MoV.kt[[l]][[i]], 
                                             alpha = label[i], 
                                             group = paste0("k=",l)))
    }
   # plot.df = plot.df %>% rbind(data.frame(X = Xvec, Y=MoV.mu, alpha=0, group = paste0("k=",l)))
  }
  plot.df = plot.df %>% mutate(alpha = as.factor(alpha))
  gg = ggplot(plot.df) + 
    geom_line(aes(x=X, y=Y,color=alpha, size = alpha)) + 
    theme(panel.background = element_rect(fill = 'white', colour = 'black')) + 
    scale_color_manual(values = c("-2" = '#ff3333', 
                                  "-1" = "#ffb3b3", 
                                  "0" = 'black', 
                                  "1" = "#b3ccff",
                                  "2" = "#3377ff")) +
    scale_size_manual(values = c("-2" = 0.5, 
                                 "-1" = 0.5, 
                                 "0"  = 1,
                                 "1"  = 0.5,
                                 "2"  = 0.5)) + 
    facet_wrap(~group, ncol = length(MoV.kt)) + 
    xlab(xlabel) + 
    ylab(ylabel) 
  return(gg)
}
