function nn = initializeNeuralNetwork(size,actFun,inSize,outSize, ...
    method,seed,mu,sigma)
    % Set network architecture
    if strcmp(size,'cnn3')
        dltLayers = [...
            imageInputLayer(inSize,'Normalization','zscore',...
                'Mean',mu,'StandardDeviation',sigma)
            convolution2dLayer([4 4],5,'Stride',[2 2])
            reluLayer
            convolution2dLayer([4 4],10,'Stride',[1 1])
            reluLayer
            fullyConnectedLayer(100)
            reluLayer
            fullyConnectedLayer(outSize)
        ];
    elseif strcmp(size,'cnn3-bn')
        dltLayers = [...
            imageInputLayer(inSize,'Normalization','zscore',...
                'Mean',mu,'StandardDeviation',sigma)
            convolution2dLayer([4 4],5,'Stride',[2 2])
            batchNormalizationLayer
            reluLayer
            convolution2dLayer([4 4],10,'Stride',[1 1])
            batchNormalizationLayer
            reluLayer
            fullyConnectedLayer(100)
            batchNormalizationLayer
            reluLayer
            fullyConnectedLayer(outSize)
        ];
    elseif strcmp(size,'cnn6')
        dltLayers = [...
            imageInputLayer(inSize,'Normalization','zscore',...
                'Mean',mu,'StandardDeviation',sigma)
            convolution2dLayer([3 3],32,'Stride',[1 1])
            reluLayer
            convolution2dLayer([4 4],32,'Stride',[2 2])
            reluLayer
            convolution2dLayer([3 3],64,'Stride',[1 1])
            reluLayer
            convolution2dLayer([4 4],64,'Stride',[2 2])
            reluLayer
            fullyConnectedLayer(512)
            reluLayer
            fullyConnectedLayer(512)
            reluLayer
            fullyConnectedLayer(outSize)
        ];
    elseif strcmp(size,'cnn6-bn')
        dltLayers = [...
            imageInputLayer(inSize,'Normalization','zscore',...
                'Mean',mu,'StandardDeviation',sigma)
            convolution2dLayer([3 3],32,'Stride',[1 1])
            batchNormalizationLayer
            reluLayer
            convolution2dLayer([4 4],32,'Stride',[2 2])
            batchNormalizationLayer
            reluLayer
            convolution2dLayer([3 3],64,'Stride',[1 1])
            batchNormalizationLayer
            reluLayer
            convolution2dLayer([4 4],64,'Stride',[2 2])
            batchNormalizationLayer
            reluLayer
            fullyConnectedLayer(512)
            batchNormalizationLayer
            reluLayer
            fullyConnectedLayer(512)
            batchNormalizationLayer
            reluLayer
            fullyConnectedLayer(outSize)
        ];
    elseif startsWith(size,'nn3')
        % Specify number of layers and neurons.
        l = 3;
        n = 100;
        % Add input layer
        dltLayers = [featureInputLayer(prod(inSize), ...
            'Normalization','zscore','Mean',mu,'StandardDeviation',sigma)];
        for k=1:l
            % Instantiate activation layer
            if strcmp(actFun,'relu')
                actLayer = reluLayer;
            elseif strcmp(actFun,'tanh')
                actLayer = tanhLayer;
            else
                error('Invalid name for activation function: %s',actFun)
                exit
            end
            % Append linear layer
            dltLayers = [dltLayers; fullyConnectedLayer(n)];
            if endsWith(size,'-bn')
                dltLayers = [dltLayers; batchNormalizationLayer];
            end
            % Append activation layer
            dltLayers = [dltLayers; actLayer];
        end
        % Add output layers
        dltLayers = [dltLayers; fullyConnectedLayer(outSize)];
    end
    
    % Load untrained layers
    nn = neuralNetwork.convertDLToolboxNetwork( ...
        num2cell(dlnetwork(dltLayers).Layers) ...
    );
    
    % Initialize weights and biases of the layers
    nn.initWeights(method,seed);
end