% from: https://de.mathworks.com/help/deeplearning/ug/train-a-variational-autoencoder-vae-to-generate-images.html
function X = processLabelsMNIST(filename)
dataFolder = fullfile(tempdir,'mnist');
gunzip(filename,dataFolder)
[~,name,~] = fileparts(filename);
[fileID,errmsg] = fopen(fullfile(dataFolder,name),'r','b');
if fileID < 0
    error(errmsg);
end
magicNum = fread(fileID,1,'int32',0,'b');
if magicNum == 2049
    % fprintf('\nRead MNIST label data...\n')
end
numImages = fread(fileID,1,'int32',0,'b');
% fprintf('Number of labels in the dataset: %6d ...\n',numImages);
X = fread(fileID,inf,'unsigned char');
X = reshape(X,[],1);

% X = discretize(X, 0:1:9, 'categorical');

X = categorical(X);

fclose(fileID);
end