function imgs_ = applyCropsAndFlips(imgs,cropSize,cropType,randomFlips)
    % Apply crops.
    switch cropType
        case 'center'
            % Obtain image size.
            imgSize = size(imgs,1:3);
            % Obtain number of images.
            N = size(imgs,4);
            % Compute center crops.
            cropCenter = repmat(floor(imgSize(1:2)/2)',1,N);
            % Crop images.
            imgs_ = aux_crop(imgs,cropSize,cropCenter);
        case 'random'
            % Obtain image size.
            imgSize = size(imgs,1:3);
            % Obtain number of images.
            N = size(imgs,4);
            % Compute random crops.
            cropCenter = ceil((imgSize(1:2) - cropSize(1:2))'.*rand(2,N)) ...
                + floor(cropSize(1:2)'/2);
            % Crop images.
            imgs_ = aux_crop(imgs,cropSize,cropCenter);
        case 'none'
            % Apply no crops.
            imgs_ = imgs;
        otherwise
            error('Invalid crop-type: %s',cropType)
    end
    % Apply random flips.
    if randomFlips
        % Compute horizontal random flips.
        flipLR = logical(randi([0 1],1,N));
        imgs_(:,:,:,flipLR) = flip(imgs_(:,:,:,flipLR),2);
    end
end

%% Auxiliary Functions. ---------------------------------------------------

function imgs_ = aux_crop(imgs,cropSize,center)
    % Crop image to size around a specified center.

    % Obtain image size.
    imgSize = size(imgs,1:3);
    % Obtain number of images.
    N = size(imgs,4);
    % Compute indices of the crop rectangle.
    cropTL = center - floor(cropSize(1:2)/2)';
    % Compute indices of pixels to keep.
    idxh = repmat((1:cropSize(1))' + cropTL(1,:) - 1,...
        cropSize(2)*imgSize(3),1);
    idxw = repmat(repelem((1:cropSize(2))' + cropTL(2,:) - 1,...
        cropSize(2),1),imgSize(3),1);
    idx = sub2ind([imgSize N],...
        idxh(:)',...
        idxw(:)',...
        repmat(repelem(1:imgSize(3),1,prod(cropSize(1:2))),1,N),...
        repelem(1:N,1,prod(cropSize(1:2))*imgSize(3)) ...
    );
    % Crop images.
    imgs_ = reshape(imgs(idx),[cropSize N]);
end
