function [trainTime,names] = extractTrainTimes(resFiles,numConfigs)
    % Number of runs.
    N = length(resFiles);
    
    % Store training times scores.
    trainTimes = zeros(numConfigs,N);
    % Store names of the configurations.
    names = {};
    
    for r=1:length(resFiles)
        fprintf('Extracting training times, run (%d/%d)...\n',r,length(resFiles));
        % Load results
        load(resFiles{r},'results');

        % Compute accuracy for each configuration
        for c=1:length(results)
            fprintf('--- config "%s" (%d/%d)...',results{c}.name,c,length(results));
            if r == 1
                % Store names of the configurations
                names = [names; results{c}.name];
            end
 
            % Store training time.
            trainTimes(c,r) = results{c}.trainingTime;

            fprintf(' done\n');
        end
        % Clean up workspace
        clearvars results
    end

    % Compute minimum training time across the different runs.
    trainTime = min(trainTimes,[],2);
end
