function [trainXImg,trainL,valXImg,valL,inSize] = processTinyImageNet(datasetDir)

% Define the train, validation, and test folders
trainFolder = fullfile(datasetDir, 'train');
valFolder = fullfile(datasetDir, 'val');
% The test images are not labeled; thus, the validation data is used for
% testing.

% Specify image size
inSize = [64 64 3];

% Step 1: Load Training Data
% Get all class folders
classFolders = dir(trainFolder);
classFolders = classFolders([classFolders.isdir] & ~ismember({classFolders.name}, {'.', '..'}));

% Obtain number of classes.
numClasses = numel(classFolders);
% Initialize variables
trainXImg = zeros([inSize 100000],'uint8');
trainTInt = zeros([1 100000]);

% Loop over each class folder to load images and labels.
for i = 1:numClasses
    classFolder = fullfile(trainFolder, classFolders(i).name, 'images');
    imageFiles = dir(fullfile(classFolder, '*.JPEG'));
    
    % Load and store each image
    for j = 1:numel(imageFiles)
        % Read the image
        img = imread(fullfile(classFolder, imageFiles(j).name));
        % Resize the image
        img_ = imresize(img, inSize(1:2));
        if size(img_,3) ~= inSize(3)
            img_ = repmat(img_,1,1,inSize(3));
        end
        % Store the image
        idx = (i-1)*500 + j;
        trainXImg(:,:,:,idx) = img_;
        % Store the target 
        trainTInt(idx) = i;
    end
end
% Convert labels to categories.
trainL = categorical(trainTInt);

% Load Validation Data; parse val_annotations.txt
valAnnotationsFile = fullfile(valFolder, 'val_annotations.txt');
valAnnotations = readtable(valAnnotationsFile, 'Delimiter', '\t', ...
    'ReadVariableNames', false);
valAnnotations.Properties.VariableNames = {'ImageName', 'Class', ...
    'XMin', 'YMin', 'XMax', 'YMax'};

% Initialize variables for validation images and labels
valXImg = zeros([inSize height(valAnnotations)],'uint8');
valTInt = zeros([1 height(valAnnotations)]);

% Load validation images and labels
valImageFolder = fullfile(valFolder, 'images');
for i = 1:height(valAnnotations)
    % Read the image
    img = imread(fullfile(valImageFolder, valAnnotations.ImageName{i}));
    % Resize the image
    img_ = imresize(img, inSize(1:2));
    if size(img_,3) ~= inSize(3)
        img_ = repmat(img_,1,1,inSize(3));
    end
    % Store the image
    valXImg(:,:,:,i) = img_;
    % Store the target 
    classIdx = find(strcmp({classFolders.name}, valAnnotations.Class{i}));
    valTInt(i) = classIdx;
end
% Convert labels to categories.
valL = categorical(valTInt);

end