## Quick Start
### 1. Install [Singularity](https://sylabs.io/guides/3.5/user-guide/introduction.html) (optional)
If you don't want to install Singularity, make sure that you have all dependecies from Singularity.def (python3, numpy, pytorch, etc.)

a. Pull an image 
````
singularity pull library://k3nfalt/default/python_ml:sha256.37fc4c8d86b92f0ac80f7a3a729d2a3d0294ea3c3895957bc7f647f1ef922745
````
b. Open a shell console of the image
````
singularity shell --nv ~/python_ml_sha256.37fc4c8d86b92f0ac80f7a3a729d2a3d0294ea3c3895957bc7f647f1ef922745.sif
````
### 2. Prepare scripts for experiments
````
source prepare.sh && python3.7 ./code/distributed_optimization_library/experiments/bidirectional_compression/config_libsvm_bidirectional_compression.py --dumps_path SOME_PATH --dataset_path PATH_TO_DATASETS --dataset cifar10 --experiments_name accelerated_bidirectional_compression_cifar10_numnodes_10_log_reg_rand_k_top_k_noc_1000_noc_1000_acc_only_diana_more_steps_48_hours --num_nodes_list 10 --step_size_range -20 2 --number_of_seeds 1 --number_of_iterations 2000000 --algorithm_names accelerated_bidirectional_diana diana_ef21_primal --quality_check_rate 100 --cpus_per_task 10 --number_of_processes 10 --oracle gradient --function logistic_regression --compressor rand_k_top_k --time 48 --number_of_coordinates 1000 --number_of_coordinates_master 1000 --calculate_accuracy --not_only_intel --parallel --acc_sum_gamma_inverse_omega
````
````
source prepare.sh && python3.7 ./code/distributed_optimization_library/experiments/bidirectional_compression/config_libsvm_bidirectional_compression.py --dumps_path SOME_PATH --dataset_path PATH_TO_DATASETS --dataset cifar10 --experiments_name accelerated_bidirectional_compression_cifar10_numnodes_100_log_reg_rand_k_top_k_noc_1000_noc_1000_acc_only_diana_more_steps_48_hours --num_nodes_list 100 --step_size_range -20 2 --number_of_seeds 1 --number_of_iterations 2000000 --algorithm_names accelerated_bidirectional_diana diana_ef21_primal --quality_check_rate 100 --cpus_per_task 10 --number_of_processes 10 --oracle gradient --function logistic_regression --compressor rand_k_top_k --time 48 --number_of_coordinates 1000 --number_of_coordinates_master 1000 --calculate_accuracy --not_only_intel --parallel --acc_sum_gamma_inverse_omega
````
````
source prepare.sh && python3.7 ./code/distributed_optimization_library/experiments/bidirectional_compression/config_libsvm_bidirectional_compression.py --dumps_path SOME_PATH --dataset_path PATH_TO_DATASETS --dataset real-sim --experiments_name accelerated_bidirectional_compression_real-sim_numnodes_100_log_reg_rand_k_top_k_noc_1000_noc_1000_acc_only_diana_48_hours --num_nodes_list 100 --step_size_range 0 20 --number_of_seeds 1 --number_of_iterations 50000 --algorithm_names accelerated_bidirectional_diana diana_ef21_primal --quality_check_rate 100 --cpus_per_task 10 --number_of_processes 10 --oracle gradient --function logistic_regression --compressor rand_k_top_k --time 48 --number_of_coordinates 1000 --number_of_coordinates_master 1000 --calculate_accuracy --not_only_intel --parallel --acc_sum_gamma_inverse_omega
````
````
source prepare.sh && python3.7 ./code/distributed_optimization_library/experiments/bidirectional_compression/config_libsvm_bidirectional_compression.py --dumps_path SOME_PATH --dataset_path PATH_TO_DATASETS --dataset real-sim --experiments_name accelerated_bidirectional_compression_real-sim_numnodes_100_log_reg_identity_acc_only_diana_48_hours --num_nodes_list 100 --step_size_range 0 20 --number_of_seeds 1 --number_of_iterations 5000 --algorithm_names accelerated_bidirectional_diana --quality_check_rate 100 --cpus_per_task 10 --number_of_processes 10 --oracle gradient --function logistic_regression --compressor identity --time 48 --number_of_coordinates 1000 --number_of_coordinates_master 1000 --calculate_accuracy --not_only_intel --parallel --acc_sum_gamma_inverse_omega
````
### 3. Execute scripts
````
sh SOME_PATH/EXPERIMENTS_NAME/singularity_*.sh
````
### 4. Plot results with the jupyter notebooks in the folder plot
