# Enhancing Graph Classification Robustness with Singular Pooling

This repository is the official implementation of our paper "Enhancing Graph Classification Robustness with Singular Pooling" that is submitted to Neurips 2025.

## Requirements

Code is written in Python 3.6 and requires:

- PyTorch
- NetworkX

We note that we deal with the GNN using dense adjancency matrices given our need to do adversarial attacks.

## Datasets
As specified in the paper, we use the graph classification datasets from the TUDataset benchmark:
- Bioinformatics (D&D, PROTEINS, ENZYMES)
- Molecules (NCI1, ER_MD)
- Images (MSRC_9)
- Social graphs (IMDB-B, REDDIT-B)


All these datasets are part of the torch_geometric datasets and can directly be downloaded when running the code.


## Training and Evaluation

To train and evaluate the model in the paper, the user should specify the following :

- Dataset : The dataset to be used
- hidden_dimension: The hidden dimension used in the model
- Pooling Method: The pooling strategy to be used (including our proposed RS-Pool).

To run a normal code of RS-Pool with a GCN backbone, using the generic hyper-parameters:

```bash
python run_pgd.py --name_dataset DD --pooling rs-pool
```

To use for instance the Sum Pooling:
```bash
python run_pgd.py --name_dataset DD --pooling sum
```

In order to run using the GIN backbone:
```bash
python run_pgd_gin.py --name_dataset DD --pooling rs-pool
```

Additional implementation details are specified in the paper. 
