from isolet_experiments_col_dim_large import conduct_trials_isolet_col_large_forest_cover
import os
from dataloader import load_forest_cover
import pickle
import argparse

RESULTS_DIR = "Results/"

if __name__ == "__main__":
    # parsing commandline argumentt 
    parser = argparse.ArgumentParser()
    parser.add_argument("--test_rank")
    args = parser.parse_args()
    test_rank_arg = int(args.test_rank)

    # Load the dataset.
    A, Ais = load_forest_cover("forest_cover_500x3000.npy")
    print("Forest Cover Data Shape: ", A.shape) 

    # Fix parameters.
    test_rank = test_rank_arg 
    num_trials = 15
    cauchy_size = 4 * test_rank
    coreset_size = 4 * test_rank
    print("Test rank: %d" % test_rank)

    # Conduct the trial and pickle the results.
    results_object = conduct_trials_isolet_col_large_forest_cover(A=A, Ais=Ais, approx_rank=test_rank, num_trials=num_trials,
     cauchy_size=cauchy_size, coreset_size=coreset_size, dataset_name="forest_cover")

    # if not os.path.isdir(RESULTS_DIR): 
    #     os.mkdir(RESULTS_DIR) 

    # filepath = RESULTS_DIR + "forest_cover_rank%d.pickle" % test_rank 
    # with open(filepath, "wb") as outfile:
    #     pickle.dump(results_object, outfile)