import pickle
import json
import argparse
import os
import glob

# UV_list_option: 0: UV_list = None 
#                 1: UV_list = [UV corresponding to the smallest error in error_list]
def pickle_to_json(pickle_filename, json_filename, UV_list_option=0):
    with open(pickle_filename, "rb") as pickle_file:
        obj = pickle.load(pickle_file)

    if UV_list_option == 0: 
        obj.UV_list = None
    else: 
        # find trial that has the least error 
        best_trial = None
        best_error = float('inf')
        for trial_num, error in enumerate(obj.error_list): 
            if error < best_error:
                best_error = error
                best_trial = trial_num
        best_UV = obj.UV_list[best_trial]
        obj.UV_list = [best_UV.tolist()]

    with open(json_filename, "w") as json_file:
        json.dump(obj.__dict__, json_file)

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--directory_name")
    args = parser.parse_args()
    dir_name = str(args.directory_name)

    # Convert and write
    for checkpoint_file in glob.iglob(dir_name + "/*.pickle"):
        name, extension = os.path.splitext(checkpoint_file)
        pickle_filename = checkpoint_file
        json_filename = name + ".json"
        pickle_to_json(pickle_filename, json_filename, UV_list_option=1)