import json 
from caltech101_experiments import ALL_IMAGE_FILEPATHS
from experiment_stats import EXPERIMENT_STATS_DIR
from dataloader import save_image 
import numpy as np 
import os 

CALTECH101_LOW_RANK_IMAGES_DIR = "Caltech101_Low_Rank_Images/"

def generate_low_rank_images_caltech101(): 
    # iterate all images
    for image_num, _ in ALL_IMAGE_FILEPATHS: 
        filepath = EXPERIMENT_STATS_DIR + "caltech101_image%d_experiment_stats.json" % image_num
        data = json.load(open(filepath, 'rb')) 

        test_ranks = data['test_ranks'] 
        best_UVs = data['best_UVs'] 
 
        # iterate all ranks 
        for idx, approx_rank in enumerate(test_ranks): 
            svd_UV, greedy_best_UV, sparse1_best_UV, sparse2_best_UV = best_UVs[idx] 

            # save svd_UV
            svd_filepath = CALTECH101_LOW_RANK_IMAGES_DIR + "image%d_rank%d_svd" % (image_num, approx_rank)
            save_image(data=np.array(svd_UV), filepath= svd_filepath) 

            # save greedy_best_UV 
            greedy_filepath = CALTECH101_LOW_RANK_IMAGES_DIR + "image%d_rank%d_greedy" % (image_num, approx_rank)
            save_image(data=np.array(greedy_best_UV), filepath=greedy_filepath)

            # save sparse embedding UVs
            sparse1_filepath = CALTECH101_LOW_RANK_IMAGES_DIR + "image%d_rank%d_sparse1" % (image_num, approx_rank)
            save_image(data=np.array(sparse1_best_UV), filepath=sparse1_filepath)

            sparse2_filepath = CALTECH101_LOW_RANK_IMAGES_DIR + "image%d_rank%d_sparse2" % (image_num, approx_rank)
            save_image(data=np.array(sparse2_best_UV), filepath=sparse2_filepath)

if __name__ == '__main__':
    save_dir = CALTECH101_LOW_RANK_IMAGES_DIR 
    if not os.path.isdir(save_dir): 
        os.mkdir(save_dir)

    generate_low_rank_images_caltech101()
 
