from lewis_sampling import *

class Server(object):

    def __init__(self, Ai):
        self.Ai = Ai
        self.SAi = None
        self.SAiTi = None
        self.coreset_indices = None
        self.S = None

    def apply_left_sketch(self):
        self.SAi = self.S @ self.Ai

    def l1_lewis_weight_sample_SA_columns(self, sample_size):
        Ti, self.coreset_indices = perform_l1_lewis_weight_sampling(A=np.transpose(self.SAi), sample_rows=sample_size)
        self.SAiTi = self.SAi @ Ti.T

    def generate_coreset(self, coreset_size):
        self.apply_left_sketch()
        self.l1_lewis_weight_sample_SA_columns(coreset_size)

    def get_SAiTi(self):
        return self.SAiTi

    def get_coreset_indices(self):
     	return self.coreset_indices

    def get_coreset_size(self):
        return len(self.coreset_indices)

    def get_selected_columns(self, selected_coreset_indices):
        selected_indices = self.coreset_indices[selected_coreset_indices]
        return self.Ai[:, selected_indices]





