import numpy as np
from sklearn.linear_model import HuberRegressor
from sklearn.linear_model import LinearRegression
import time

def dense_cauchy_matrix(size): 
	A1 = np.random.normal(0, 1, size=size)
	A2 = np.random.normal(0, 1, size=size)
	return A1 / A2 

# Returns a list L' whose first entry is 0
# and such that L'[i] is the sum of the first
# i entries of L. The length of L' is 1 more
# than that of L.
def scan(L):
	return_list = [0] * (len(L) + 1)
	for i in range(1, len(L) + 1):
		return_list[i] = return_list[i - 1] + L[i - 1]
	return return_list

def huber_regression_coeffs(A, y): 
	w = None
	try: 
		huber = HuberRegressor(fit_intercept=False).fit(A, y) 
		w = huber.coef_
	except: 
		print("HuberRegressor error occured") 
		lr = LinearRegression(fit_intercept=False).fit(A, y) 
		w = lr.coef_

	return w

def rank_k_svd(A, k):
	U, S, VH = np.linalg.svd(A)
	U = U[:, :k]
	S = S[:k]
	S = np.diag(S)
	VH = VH[:k, :]
	return U @ (S @ VH)

def rank_k_svd_with_work_time(A, k): 
	start = time.process_time() 
	svd_approx = rank_k_svd(A, k)
	end = time.process_time() 

	return svd_approx, end - start


if __name__ == "__main__":
	A = np.random.randn(10, 8)
	s = np.linalg.svd(A)[1]

	k = 7
	M = rank_k_svd(A, k)
	s_prime = np.linalg.svd(M)[1]

	s = s[:k]
	s_prime = s_prime[:k]
	tol = 1e-5
	print((np.abs(s - s_prime) <= tol))


