## @knitr analyzePC

library(readxl)
library(coin)

mydata <- read_excel("E:/Mia/Perspective Charts/Analysis Documents/UserStudyResults.xlsx", sheet = "Summary")
mydata <- mydata[c(1:3, 8:9)]

analyze <- function(other, ours) {
	g = factor(c(rep("other", length(other)), rep("ours", length(ours))))
	v = c(other, ours)
	wilcox_test(v ~ g, distribution="exact")
}

effectsize <- function(res, other, ours) {
	z = statistic(res)
	numentries = (length(other) + length(ours))
	abs(z) / sqrt(numentries)
}

## SECTION 1 & 2 ##

# Get all data for the section
section <-mydata[mydata$Section  %in% c("1", "2"),]

# separate data between "our" chart and the comparison chart
other_data <- section[section$Chart %in% c("Traditional Bar"),]
our_data <- section[section$Chart %in% c("Slanted"),]

# Separate based on the question number, analyze only Absolute % Error
other_q1 <- other_data[other_data$Question %in% c("1"),]$`Absolute % Error`
ours_q1 <- our_data[our_data$Question %in% c("1"),]$`Absolute % Error`

other_q2 <- other_data[other_data$Question %in% c("2"),]$`Absolute % Error`
ours_q2 <- our_data[our_data$Question %in% c("2"),]$`Absolute % Error`

other_q3 <- other_data[other_data$Question %in% c("3"),]$`Absolute % Error`
ours_q3 <- our_data[our_data$Question %in% c("3"),]$`Absolute % Error`

other_q4 <- other_data[other_data$Question %in% c("4"),]$`Absolute % Error`
ours_q4 <- our_data[our_data$Question %in% c("4"),]$`Absolute % Error`

other_q5 <- other_data[other_data$Question %in% c("5"),]$`Absolute % Error`
ours_q5 <- our_data[our_data$Question %in% c("5"),]$`Absolute % Error`

# Analysis for question 1

res <- analyze(other_q1, ours_q1)
questions <- c(1)
pvals <- c(pvalue(res))
pvals_1 <- c(pvalue(res))
effects <- c(effectsize(res, other_q1, ours_q1))

# Analysis for question 2

res <- analyze(other_q2, ours_q2)
questions <- c(questions, 2)
pvals <- c(pvals, pvalue(res))
pvals_1 <- c(pvals_1, pvalue(res))
effects <- c(effects, effectsize(res, other_q2, ours_q2))

# Analysis for question 3

res <- analyze(other_q3, ours_q3)
questions <- c(questions, 3)
pvals <- c(pvals, pvalue(res))
pvals_1 <- c(pvals_1, pvalue(res))
effects <- c(effects, effectsize(res, other_q3, ours_q3))

# Analysis for question 4

res <- analyze(other_q4, ours_q4)
questions <- c(questions, 4)
pvals <- c(pvals, pvalue(res))
pvals_1 <- c(pvals_1, pvalue(res))
effects <- c(effects, effectsize(res, other_q4, ours_q4))

# Analysis for question 5
res <- analyze(other_q5, ours_q5)
questions <- c(questions, 5)
pvals <- c(pvals, pvalue(res))
pvals_1 <- c(pvals_1, pvalue(res))
effects <- c(effects, effectsize(res, other_q5, ours_q5))

sections <- c(1, 1, 1, 1, 1)

adj_pvals <- c(p.adjust(pvals_1, "BH"))

## SECTION 3 & 4 ##

section <- mydata[mydata$Section  %in% c("3", "4"),]
sections <- c(sections, 2, 2, 2, 2)

# separate data between "our" chart and the comparison chart
other_data <- section[section$Chart %in% c("Scale-Stack"),]
our_data <- section[section$Chart %in% c("Stepped"),]

# Separate based on the question number, analyze only Absolute % Error
other_q1 <- other_data[other_data$Question %in% c("1"),]$`Absolute % Error`
ours_q1 <- our_data[our_data$Question %in% c("1"),]$`Absolute % Error`

other_q2 <- other_data[other_data$Question %in% c("2"),]$`Absolute % Error`
ours_q2 <- our_data[our_data$Question %in% c("2"),]$`Absolute % Error`

other_q3 <- other_data[other_data$Question %in% c("3"),]$`Absolute % Error`
ours_q3 <- our_data[our_data$Question %in% c("3"),]$`Absolute % Error`

other_q4 <- other_data[other_data$Question %in% c("4"),]$`Absolute % Error`
ours_q4 <- our_data[our_data$Question %in% c("4"),]$`Absolute % Error`

# Analysis for question 1

res <- analyze(other_q1, ours_q1)
questions <- c(questions, 1)
pvals <- c(pvals, pvalue(res))
pvals_2 <- c(pvalue(res))
effects <- c(effects, effectsize(res, other_q1, ours_q1))

# Analysis for question 2

res <- analyze(other_q2, ours_q2)
questions <- c(questions, 2)
pvals <- c(pvals, pvalue(res))
pvals_2 <- c(pvals_2, pvalue(res))
effects <- c(effects, effectsize(res, other_q2, ours_q2))

# Analysis for question 3

res <- analyze(other_q3, ours_q3)
questions <- c(questions, 3)
pvals <- c(pvals, pvalue(res))
pvals_2 <- c(pvals_2, pvalue(res))
effects <- c(effects, effectsize(res, other_q3, ours_q3))

# Analysis for question 4

res <- analyze(other_q4, ours_q4)
questions <- c(questions, 4)
pvals <- c(pvals, pvalue(res))
pvals_2 <- c(pvals_2, pvalue(res))
effects <- c(effects, effectsize(res, other_q4, ours_q4))

adj_pvals <- c(adj_pvals, p.adjust(pvals_2, "BH"))

## SECTION 5 & 6 ##

section <- mydata[mydata$Section  %in% c("5", "6"),]
sections <- c(sections, 3, 3, 3, 3)

# separate data between "our" chart and the comparison chart
other_data <- section[section$Chart %in% c("Broken"),]
our_data <- section[section$Chart %in% c("Stepped"),]

# Separate based on the question number, analyze only Absolute % Error
other_q1 <- other_data[other_data$Question %in% c("1"),]$`Absolute % Error`
ours_q1 <- our_data[our_data$Question %in% c("1"),]$`Absolute % Error`

other_q2 <- other_data[other_data$Question %in% c("2"),]$`Absolute % Error`
ours_q2 <- our_data[our_data$Question %in% c("2"),]$`Absolute % Error`

other_q3 <- other_data[other_data$Question %in% c("3"),]$`Absolute % Error`
ours_q3 <- our_data[our_data$Question %in% c("3"),]$`Absolute % Error`

other_q4 <- other_data[other_data$Question %in% c("4"),]$`Absolute % Error`
ours_q4 <- our_data[our_data$Question %in% c("4"),]$`Absolute % Error`

# Analysis for question 1

res <- analyze(other_q1, ours_q1)
questions <- c(questions, 1)
pvals <- c(pvals, pvalue(res))
pvals_3 <- c(pvalue(res))
effects <- c(effects, effectsize(res, other_q1, ours_q1))

# Analysis for question 2

res <- analyze(other_q2, ours_q2)
questions <- c(questions, 2)
pvals <- c(pvals, pvalue(res))
pvals_3 <- c(pvals_3, pvalue(res))
effects <- c(effects, effectsize(res, other_q2, ours_q2))

# Analysis for question 3

res <- analyze(other_q3, ours_q3)
questions <- c(questions, 3)
pvals <- c(pvals, pvalue(res))
pvals_3 <- c(pvals_3, pvalue(res))
effects <- c(effects, effectsize(res, other_q3, ours_q3))

# Analysis for question 4

res <- analyze(other_q4, ours_q4)
questions <- c(questions, 4)
pvals <- c(pvals, pvalue(res))
pvals_3 <- c(pvals_3, pvalue(res))
effects <- c(effects, effectsize(res, other_q4, ours_q4))

adj_pvals <- c(adj_pvals, p.adjust(pvals_3, "BH"))

## SECTION 7 & 8 ##

section <- mydata[mydata$Section  %in% c("7", "8"),]
sections <- c(sections, 4, 4, 4, 4)

# separate data between "our" chart and the comparison chart
other_data <- section[section$Chart %in% c("Radial"),]
our_data <- section[section$Chart %in% c("Circular"),]

# Separate based on the question number, analyze only Absolute % Error
other_q1 <- other_data[other_data$Question %in% c("1"),]$`Absolute % Error`
ours_q1 <- our_data[our_data$Question %in% c("1"),]$`Absolute % Error`

other_q2 <- other_data[other_data$Question %in% c("2"),]$`Absolute % Error`
ours_q2 <- our_data[our_data$Question %in% c("2"),]$`Absolute % Error`

other_q3 <- other_data[other_data$Question %in% c("3"),]$`Absolute % Error`
ours_q3 <- our_data[our_data$Question %in% c("3"),]$`Absolute % Error`

other_q4 <- other_data[other_data$Question %in% c("4"),]$`Absolute % Error`
ours_q4 <- our_data[our_data$Question %in% c("4"),]$`Absolute % Error`

# Analysis for question 1

res <- analyze(other_q1, ours_q1)
questions <- c(questions, 1)
pvals <- c(pvals, pvalue(res))
pvals_4 <- c(pvalue(res))
effects <- c(effects, effectsize(res, other_q1, ours_q1))

# Analysis for question 2

res <- analyze(other_q2, ours_q2)
questions <- c(questions, 2)
pvals <- c(pvals, pvalue(res))
pvals_4 <- c(pvals_4, pvalue(res))
effects <- c(effects, effectsize(res, other_q2, ours_q2))

# Analysis for question 3

res <- analyze(other_q3, ours_q3)
questions <- c(questions, 3)
pvals <- c(pvals, pvalue(res))
pvals_4 <- c(pvals_4, pvalue(res))
effects <- c(effects, effectsize(res, other_q3, ours_q3))

# Analysis for question 4

res <- analyze(other_q4, ours_q4)
questions <- c(questions, 4)
pvals <- c(pvals, pvalue(res))
pvals_4 <- c(pvals_4, pvalue(res))
effects <- c(effects, effectsize(res, other_q4, ours_q4))

adj_pvals <- c(adj_pvals, p.adjust(pvals_4, "BH"))

## SECTION 9 & 10 ##

section <- mydata[mydata$Section  %in% c("9", "10"),]
sections <- c(sections, 5, 5, 5, 5)

# separate data between "our" chart and the comparison chart
other_data <- section[section$Chart %in% c("Traditional Bar"),]
our_data <- section[section$Chart %in% c("Circular"),]

# Separate based on the question number, analyze only Absolute % Error
other_q1 <- other_data[other_data$Question %in% c("1"),]$`Absolute % Error`
ours_q1 <- our_data[our_data$Question %in% c("1"),]$`Absolute % Error`

other_q2 <- other_data[other_data$Question %in% c("2"),]$`Absolute % Error`
ours_q2 <- our_data[our_data$Question %in% c("2"),]$`Absolute % Error`

other_q3 <- other_data[other_data$Question %in% c("3"),]$`Absolute % Error`
ours_q3 <- our_data[our_data$Question %in% c("3"),]$`Absolute % Error`

other_q4 <- other_data[other_data$Question %in% c("4"),]$`Absolute % Error`
ours_q4 <- our_data[our_data$Question %in% c("4"),]$`Absolute % Error`

# Analysis for question 1

res <- analyze(other_q1, ours_q1)
questions <- c(questions, 1)
pvals <- c(pvals, pvalue(res))
pvals_5 <- c(pvalue(res))
effects <- c(effects, effectsize(res, other_q1, ours_q1))

# Analysis for question 2

res <- analyze(other_q2, ours_q2)
questions <- c(questions, 2)
pvals <- c(pvals, pvalue(res))
pvals_5 <- c(pvals_5, pvalue(res))
effects <- c(effects, effectsize(res, other_q2, ours_q2))

# Analysis for question 3

res <- analyze(other_q3, ours_q3)
questions <- c(questions, 3)
pvals <- c(pvals, pvalue(res))
pvals_5 <- c(pvals_5, pvalue(res))
effects <- c(effects, effectsize(res, other_q3, ours_q3))

# Analysis for question 4

res <- analyze(other_q4, ours_q4)
questions <- c(questions, 4)
pvals <- c(pvals, pvalue(res))
pvals_5 <- c(pvals_5, pvalue(res))
effects <- c(effects, effectsize(res, other_q4, ours_q4))

adj_pvals <- c(adj_pvals, p.adjust(pvals_5, "BH"))

## @knitr writePC

totalresults <- cbind(sections, questions, pvals, adj_pvals, effects)
write.csv(totalresults, 'AggregateAnalysis.csv')

## @knitr outputPC
Block <- sections
Question <- questions
Raw_P_Value <- round(pvals, 3)
P_Value <- round(adj_pvals, 3)
Effect_Size <- round(effects, 3)
##totalresults <-data.frame(Block, Question, Raw_P_Value, Effect_Size)

totalresults <-data.frame(Block, Question, Raw_P_Value, P_Value, Effect_Size)
