from .fit_base import Fit


class AnchorFit(Fit):
    def __init__(self, rules, seq):
        super().__init__(rules)
        self.seq = seq

    def fit(self,now, **kwargs):
        # print(len(now),len(self.words))
        if len(now) != len(self.seq):
            return False
        for val in self.rules:
            if self.seq[val] not in now:
                return False
            for i, x in enumerate(now):
                if x == self.seq[val]:
                    if self.seq[i] != x:
                        return False
                    break
        return True


class RexFit(Fit):
    def __init__(self, rules, seq):
        super().__init__(rules)
        self.seq = seq

    def fit(self, new, **kwargs):
        for rule in self.rules:
            x, y, dist = rule
            x = self.seq[x]
            y = self.seq[y]
            posx = -1
            posy = -1
            for i,t in enumerate(new):
                if t == x:
                    posx = i
                if t == y:
                    posy = i
            # if posx != -1 and posy != -1:
            #     print([posx, posy])
            if x == y:
                if posx < dist:
                    return False
            else:
                if dist == -1:
                    dist = dist-1
                if posx == -1 or posy == -1 or posy-posx <= dist:
                    return False
        return True


class AnchorNoDistFit(Fit):
    # def __init__(self ,rules, **kwargs):
    #     super(AnchorNoDistFit, self).__init__(rules)

    def fit(self, now, **kwargs):
        return False not in [word in now for word in self.rules]
