
import keras
from keras.preprocessing.text import Tokenizer
from keras.preprocessing import sequence
import re
from nltk.corpus import stopwords
from nltk.tokenize import word_tokenize
from nltk.stem import WordNetLemmatizer
import numpy as np
import time
import numpy as np
import sklearn
import sklearn.model_selection
import sklearn.linear_model
import sklearn.ensemble
import spacy
import lime
from lime import lime_text
import sys
from sklearn.feature_extraction.text import CountVectorizer
import mylime
import multiprocessing
import io
from mylime import lime_text_bak
import os
from subprocess import PIPE, Popen
predictin = '/home/jhliu/Myalgorithm_LIME/mypipe'
try:
    os.remove(predictin)
except FileNotFoundError as e:
    print(e)
os.mkfifo(path=predictin,mode=0o666)
predictout = '/home/jhliu/Myalgorithm_LIME/mypipe2'
try:
    os.remove(predictout)
except FileNotFoundError as e:
    print(e)
os.mkfifo(path=predictout,mode=0o666)
p = Popen("sh /home/jhliu/iclr2016/runmytestforLIME.sh", shell=True)
print("OK1")
pin = open(predictin,"w")
print("OK2")
pout = open(predictout,"r")
nlp = spacy.load('en_core_web_sm')
def predict_lr(texts):
    # p = Popen("/home/jhliu/iclr2016/runmytest.sh", stdin=PIPE, stdout=PIPE,shell=True)
    # x=str(texts).encode()
    # out,_=p.communicate(x)
    print("predict: ",end="")
    print(texts)
    pin.write(str(texts) + '\n')
    pin.flush()
    out=pout.readline()
    y=eval(out)
    if not isinstance(y,list):
        y=[y]
    return np.array(y)

class Interpret:
    def __init__(self, text):
        text=' '.join(mylime.lime_text_bak.IndexedString(text).inverse_vocab)
        print(text)
        self.text = text
        processed = nlp(text)
        self.words = np.array([x.text for x in processed], dtype='|U80')
        np.random.seed(1)

        np.random.seed(1)
        explainer = lime.lime_text.LimeTextExplainer(class_names = ['negative', 'positive'], verbose = False, mask_string = 'UUUNKKK',bow = True)
        b = time.time()
        self.explanation = explainer.explain_instance(text, classifier_fn = predict_lr,top_labels=2)
        print('Time: %s' % (time.time() - b))
        print(self.explanation.as_list())
        explainer = mylime.lime_text_bak.LimeTextExplainer(class_names = ['negative', 'positive'], verbose = False, mask_string = 'UUUNKKK')
        b = time.time()
        self.explanation = explainer.explain_instance(text, classifier_fn = predict_lr,top_labels=2,features=[[x,x,0] for x in range(len(self.words))])
        print('Time: %s' % (time.time() - b))
        print(self.explanation.as_list())
        # exit(0)
        self.explainer = mylime.lime_text_bak.LimeTextExplainer(class_names = ['negative', 'positive'], verbose = True, mask_string = 'UUUNKKK')


    def run(self, threshhold=0.9, outpath = "test.out" ):
        nrules=[[0,0,0]]
        for (j,x) in enumerate(self.words):
            posx = j
            for k in range(posx):
                nrules.append([posx,posx,k])
                # nrules.append([i,i,-(k+1)])
            for y in self.words[j + 1:]:
                posy = 0
                for i,z in enumerate(self.words):
                    if y == z:
                        posy = i
                        break
                if posy < posx:
                    raise Exception("Why x>=y")
                for k in range(0,posy-posx):
                    nrules.append([posx,posy,k])
                    # nrules.append([i,j,-(k+1)])
        print("nrules")
        print(nrules)
        f = open(outpath, "w")
        f.write(str(self.words) + '\n')
        st_time = time.time()
        res = []
        for rule in nrules:
            b=time.time()
            nrule=[rule]
            for i,x in enumerate(self.words):
                if i not in rule[:-1]:
                    nrule.append([i,i,0])
            exp = self.explainer.explain_instance(self.text,classifier_fn=predict_lr,features=nrule,top_labels=2)
            f.write("Tested rule: %s\n" % str(rule))
            f.write(str(exp.as_list())+'\n')
            f.write("time %s\n" % (time.time()-b))
            print("time %s" % (time.time()-b))
            print(exp.as_list())
            print("rule select")
            print(self.words[rule[0]],end=" ")
            print(self.words[rule[1]])
            for ru, wt in exp.as_list():
                ru=eval(ru)
                print(ru[0],end=" ")
                print(ru[1])
                if ru[0]==self.words[rule[0]] and ru[1] == self.words[rule[1]]:
                    res.append((ru,wt))
            f.flush()
        f.write("total time: %s\n" % (time.time() - st_time))
        res.sort(key = lambda ele:abs(ele[1]),reverse=True)
        f.write("result:\n%s\n" % str(res))
        f.write("\n")
        exp = self.explainer.explain_instance(self.text, classifier_fn=predict_lr, features=nrules, top_labels=2)
        f.write("Tested rule: %s\n" % str(rule))
        f.write(str(exp.as_list()) + '\n')
        f.write("time %s\n" % (time.time() - b))

        f.close()
        return "Failed"

    def checksingle_rule(self, rule):
        ret = ""
        b = time.time()
        nrule = [rule]
        for x in self.words:
            if x not in rule:
                nrule.append(x)
        exp = self.explainer.explain_instance(self.text, predict_lr, nrule)
        ret += "time %s" % (time.time() - b) + '\n'
        print("time %s" % (time.time() - b))
        print(exp.names())
        ret += str(exp.names()) + '\n'
        for i in range(len(exp.names())):
            print(exp.precision(i))
            ret += str(exp.precision(i)) + '\n'
        return ret
        # if exp.names()[0] == rule:
        #     f.write("Success")
        #     f.close()
        #     return [rule, exp.precision(0)]

    def multithread_run(self, threshhold=0.9, outpath = "test_multi.out"):
        if len(self.explanation)<2:
            self.explanation = self.words
        nrules=[]
        for (j,x) in enumerate(self.explanation):
            posx = 0
            for i, z in enumerate(self.words):
                if x == z:
                    posx = i
            for k in range(posx+1):
                nrules.append([x,x,k])
                nrules.append([x,x,-(k+1)])
            for y in self.explanation[j + 1:]:
                posy = 0
                for i,z in enumerate(self.words):
                    if y == z:
                        posy = i
                if posy < posx:
                    x, y = y, x
                    posx, posy = posy, posx
                for k in range(1,posy-posx+1):
                    nrules.append([x,y,k])
                    nrules.append([x,y,-(k+1)])
        print("nrules")
        print(nrules)
        from multiprocessing import Pool
        with Pool() as pool:
            f = open("test_multi.out", "w")
            iters = pool.imap(self.checksingle_rule,nrules,chunksize = 10)
            for ret in iters:
                f.write(ret)
            f.close()
        return "Failed"


