import keras
from keras.preprocessing.text import Tokenizer
from keras.preprocessing import sequence
import re
from nltk.corpus import stopwords
from nltk.tokenize import word_tokenize
from nltk.stem import WordNetLemmatizer
import numpy as np
import time
import numpy as np
import sklearn
import sklearn.model_selection
import sklearn.linear_model
import sklearn.ensemble
import spacy
import lime
from lime import lime_text
import sys
from sklearn.feature_extraction.text import CountVectorizer
import mylime
import multiprocessing
import io
from mylime import lime_text
import os
from subprocess import PIPE, Popen
import socket

nlp = spacy.load('en_core_web_sm')
def predict(texts):
    # p = Popen("/home/jhliu/iclr2016/runmytest.sh", stdin=PIPE, stdout=PIPE,shell=True)
    # x=str(texts).encode()
    # out,_=p.communicate(x)
    print("predict: ",end="")
    print(texts)
    print(len(texts))
    # echo-client.py


    HOST = "127.0.0.1"  # The server's hostname or IP address
    PORT = 65431  # The port used by the server
    ret = []
    for i in range(0,len(texts),10000):
        out = ""
        nowtexts = texts[i:min(i+10000, len(texts))]
        with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as s:
            s.connect((HOST, PORT))
            print(s.getsockname())
            s.sendall((str(nowtexts)+"\n").encode())
            while True:
                data = s.recv(1024)
                print(data.decode())
                if not data:
                    break
                out += data.decode()
        y=eval(out)
        if not isinstance(y,list):
            y=[y]
        print(y)
        ret+=y
    return np.array(y)

class Interpret:
    def __init__(self, text):
        text=' '.join(mylime.lime_text.IndexedString(text).inverse_vocab)
        print(text)
        self.text = text
        processed = nlp(text)
        self.words = np.array([x.text for x in processed], dtype='|U80').tolist()
        np.random.seed(1)

        np.random.seed(1)
        explainer = lime.lime_text.LimeTextExplainer(class_names = ['negative', 'positive'], verbose = False, mask_string = 'UUUNKKK',bow = True)
        b = time.time()
        self.explanation = explainer.explain_instance(text, classifier_fn = predict,top_labels=2,num_features=len(self.words))
        print('Time: %s' % (time.time() - b))
        print(self.explanation.as_list())

        self.explainer = mylime.lime_text.LimeTextExplainer(class_names = ['negative', 'positive'], verbose = True, mask_string = 'UUUNKKK')


    def run(self, threshhold=0.9, outpath = "test.out" ):
        nrules=[]
        for (j,x) in enumerate(self.words):
            posx = j
            for k in range(posx):
                nrules.append([posx,posx,k])
            for y in self.words[j + 1:]:
                posy = 0
                for i,z in enumerate(self.words):
                    if y == z:
                        posy = i
                        break
                if posy < posx:
                    raise Exception("Why x>=y")
                for k in range(-1,posy-posx):
                    nrules.append([posx,posy,k])
                    # nrules.append([i,j,-(k+1)])
        f = open(outpath, "w")
        f.write(str(self.words) + '\n')
        f.write(str(self.explanation.as_list())+'\n')
        b=time.time()
        exp = self.explainer.explain_instance(self.text, classifier_fn=predict, features=nrules, top_labels=2,num_features=len(nrules))
        f.write(str(exp.as_list()) + '\n')
        f.write("time %s\n" % (time.time() - b))

        f.close()
