
import keras
from keras.preprocessing.text import Tokenizer
from keras.preprocessing import sequence
import re
from nltk.corpus import stopwords
from nltk.tokenize import word_tokenize
from nltk.stem import WordNetLemmatizer
import numpy as np
import time
import sklearn
import sklearn.model_selection
import sklearn.linear_model
import sklearn.ensemble
import spacy
import sys
from sklearn.feature_extraction.text import CountVectorizer
import myanchor
import anchor
import multiprocessing
import io
from anchor import anchor_text
from myanchor import anchor_text
import os
import socket
from calccoverage import coverage

nlp = spacy.load('en_core_web_sm')
def predict_lr(texts):
    # p = Popen("/home/jhliu/iclr2016/runmytest.sh", stdin=PIPE, stdout=PIPE,shell=True)
    # x=str(texts).encode()
    # out,_=p.communicate(x)
    # print("predict: ",end="")
    # print(texts)
    # echo-client.py


    HOST = "127.0.0.1"  # The server's hostname or IP address
    PORT = 65432  # The port used by the server

    out = ""
    with socket.socket(socket.AF_INET, socket.SOCK_STREAM) as s:
        s.connect((HOST, PORT))
        # print(s.getsockname())
        s.sendall((str(texts)+"\n").encode())
        while True:
            data = s.recv(1024)
            # print(data.decode())
            if not data:
                break
            out += data.decode()
    y=eval(out)
    if not isinstance(y,list):
        y=[y]
    # print(y)
    return np.array(y)

class Interpret:
    def __init__(self, text):
        self.text = text
        processed = nlp(text)
        self.words = np.array([x.text for x in processed], dtype='|U80')
        np.random.seed(1)
        explainer = anchor.anchor_text.AnchorText(nlp, ['negative', 'positive'], use_unk_distribution=False)
        pred = explainer.class_names[predict_lr([text])[0]]
        print('Prediction: %s' % pred)
        b = time.time()
        exp = explainer.explain_instance(text, predict_lr, threshold=0.9, verbose=False)
        print(exp.precision())
        print(exp.names())
        self.precision = []
        for i in range(len(exp.names())):
            print(exp.precision(i))
            self.precision.append(exp.precision(i))
        print(exp.examples())
        print('Time: %s' % (time.time() - b))
        self.anchors = exp.names()
        self.explainer = myanchor.anchor_text.AnchorText(nlp, ['negative', 'positive'], use_unk_distribution=False, neg_rule=True)


    def run(self, threshhold=0.9, outpath = "test.out",use_cov = False):
        self.words = self.words.tolist()
        f = open(outpath, "w")
        f.write(str(self.words)+'\n')
        f.write(str(self.anchors)+'\n')
        f.write(str(self.precision)+'\n')

        ans = []
        mxprecision = 0
        nrules=[]
        for (j,x) in enumerate(self.words):
            posx = 0
            for i, z in enumerate(self.words):
                if x == z:
                    posx = i
            for k in range(posx):
                nrules.append([x,x,k])
            for y in self.words[j+1:]:
                posy = 0
                for i,z in enumerate(self.words):
                    if y == z:
                        posy = i
                if posy < posx:
                    x, y = y, x
                    posx, posy = posy, posx
                for k in range(-1,posy-posx):
                    nrules.append([x,y,k])
        for rule in nrules:
            b=time.time()
            nrule=[rule]
            for x in self.words:
                if x not in rule:
                    nrule.append([x,x,0])
            exp = self.explainer.explain_instance(self.text,predict_lr,nrule)
            # f.write("tested rule %s\n" % str(rule))
            # f.write("time %s\n" % (time.time()-b))
            # print("time %s" % (time.time()-b))
            # print(exp.names())
            # f.write(str(exp.names())+'\n')
            # for i in range(len(exp.names())):
            #     print(exp.precision(i))
            #     f.write(str(exp.precision(i))+'\n')
            # f.flush()
            print(exp.precision())
            if exp.precision() > threshhold:
                # print("> threshold")
                # print(rule)
                # print(ans)
                if use_cov is False:
                    for i in range(len(exp.names())):
                        if exp.precision(i)>threshhold:
                            if len(ans)==0 or i+1 < len(ans):
                                ans = exp.names(i)
                                mxprecision = exp.precision(i)
                            elif i+1 == len(ans):
                                flag = True
                                for x,y in zip(exp.names(i),ans):
                                    if x[2] > y[2]:
                                        flag =False
                                if flag:
                                    ans = exp.names(i)
                                    mxprecision = exp.precision(i)
                else:
                    for i in range(len(exp.names())):
                        if exp.precision(i)>threshhold:
                            print(exp.names(i))
                            try:
                                _,cover,_ = coverage(self.words, [eval(x) for x in exp.names(i)], self.anchors)
                                if cover[1] > mxprecision:
                                    ans = exp.names(i)
                                    mxprecision = cover[1]
                            except Exception:
                                pass
                                    

        f.write(str(ans)+"\n")
        print(ans)
        f.close()





