import os
import pickle
from utils.rank_correlation import compute_rank_correlation_from_values, display_results

if __name__ == "__main__":

    all_values_path = "results/all_values.pkl"
    output_path = "results/rank_correlation_results.pkl"

    if not os.path.exists(all_values_path):
        raise FileNotFoundError(f"Missing file: '{all_values_path}'. Please run the experiment to generate it.")

    with open(all_values_path, "rb") as f:
        all_values = pickle.load(f)

    results = compute_rank_correlation_from_values(all_values)
    
    display_results(results)

    with open(output_path, "wb") as f:
        pickle.dump(results, f)

    print(f"Rank correlation results saved to: {output_path}")
