from utils.plots import plot_flat_Rp_df
from utils.robustness import build_flattened_Rp_df
import pickle
import config.config as c
import os

if __name__ == "__main__":
    data_path = "results/all_values.pkl"
    p_values = c.P_VALUES

    if not os.path.exists(data_path):
        raise FileNotFoundError(f"Missing file: '{data_path}'. Please run the experiment to generate it.")

    with open(data_path, "rb") as f:
        all_values = pickle.load(f)

    df_flat = build_flattened_Rp_df(all_values, p_values)
    df_flat.to_csv("results/flattened_Rp_summary.csv", index=False)
    plot_flat_Rp_df(df_flat, p_values, save_path="results/Rp_plot.png")