import pickle
import os
from utils.plots import plot_spatial_signature_with_enhanced_visuals

if __name__ == "__main__":
    save_dir = "results/plots"
    results_path = "results/all_values.pkl"
    if not os.path.exists(results_path):
        raise FileNotFoundError(f"Missing file: '{results_path}'. Please run the experiment to generate it.")

    with open(results_path, "rb") as f:
        all_values = pickle.load(f)

    plot_spatial_signature_with_enhanced_visuals(all_values, save_bool=True, save_dir=save_dir)

    print(f"Spatial signatures plots saved to: {save_dir}")