
import java.io.*;
import java.util.*;

/**************************************************************************************************************************************
 * Class Utils
 *****/

class Utils implements Debuggable{
    int domain_id;
    public static Random R = new Random();

    public static String NOW;

    public static Vector ALL_NON_TRIVIAL_SUBSETS(Vector v){
	Vector ret = new Vector();
	Vector copycat = new Vector();
	int i;
	for (i=0;i<v.size();i++)
	    copycat.addElement(new String((String) v.elementAt(i)));
	
	MOVE_IN(ret, copycat);

	ret.removeElementAt(0);
	ret.removeElementAt(ret.size()-1);
	
	return ret;
    }

    public static void MOVE_IN(Vector grow, Vector shrink){
	if ( (shrink == null) || (shrink.size() == 0) )
	    Dataset.perror("Utils.class :: MOVE_IN impossible because empty list of values");

	if (grow == null)
	    Dataset.perror("Utils.class :: MOVE_IN impossible because empty grow list");	    
	
	String s = (String) shrink.elementAt(0);
	Vector v, vv;

	if (grow.size() == 0){
	    v = new Vector();
	    grow.addElement(v);
	}

	int i, sinit = grow.size(), j;
	for (i=0;i<sinit;i++){
	    vv = (Vector) grow.elementAt(i);
	    v = new Vector();
	    if (vv.size() > 0)
		for (j = 0; j < vv.size() ; j++)
		    v.addElement(new String((String) vv.elementAt(j)));
	    v.addElement(new String(s));
	    grow.addElement(v);
	}
	shrink.removeElementAt(0);
	if (shrink.size() > 0)
	    MOVE_IN(grow, shrink);
    }
    
    public static int hinge(int v){
	if (v < 0)
	    return -v;
	return 0;
    }
    
    public static long hinge(long v){
	if (v < 0)
	    return -v;
	return 0;
    }
    
    public static double min(double [] vect){
	double tv = 0.0;
	int i;
	for (i=0;i<vect.length;i++)
	    if ( (i==0) || (vect[i] < tv) )
		tv = vect[i];
	return tv;
    }

    public static double max(double [] vect){
	double tv = 0.0;
	int i;
	for (i=0;i<vect.length;i++)
	    if ( (i==0) || (tv < vect[i]) )
		tv = vect[i];
	return tv;
    }

    public static double mean(double [] vect){
	double tv = 0.0;
	int i;
	for (i=0;i<vect.length;i++)
	    tv += vect[i];
	tv /= (double) vect.length;
	return tv;
    }

    public static double stddev(double [] vect, double mean){
	double tv = 0.0;
	int i;
	for (i=0;i<vect.length;i++)
	    tv += ( (vect[i] - mean) * (vect[i] - mean) );
	tv /= (double) (vect.length - 1);
	tv = Math.sqrt(tv);
	return tv;
    }

    public static boolean outliers(double [] vect, double stddev, double coeff){
	double tv = 0.0;
	int i = 0;
	do{
	    if (Math.abs(vect[i]) > coeff * stddev)
		return true;
	    i++;
	}while (i<vect.length);
	return false;
    }

    public static double median(double [] vect){
	double [] cp = new double[vect.length];
	double tv = 0.0;
	int i;
	for (i=0;i<cp.length;i++)
	    cp[i] = vect[i];
	QuickSort.quicksort(cp);
	tv = cp[cp.length/2];
	return tv;
    }

    public static double L2(double [] vect){
	double val = 0.0;
	int i;
	for (i=0;i<vect.length;i++){
	    val += (vect[i] * vect[i]);
	}
	return Math.sqrt(val);
    }

    public static double supportEPS(double [] vect){
	double val = 0.0;
	int i;
	for (i=0;i<vect.length;i++){
	    if (Math.abs(vect[i]) > EPS)
		val += 1.0;
	}
	val /= (double) vect.length;

	return val;
    }

    public static double [] copyOf(double [] vect){
	// returns a copy of vect
	double [] val = new double [vect.length];
	int i;
	for (i=0;i<vect.length;i++){
	    val[i] = vect[i];
	}
	return val;
    }

    public static double [] add(double [] feat1, double [] feat2){
	//adds feat1 and feat2
	if (feat1.length != feat2.length)
	    Dataset.perror("Utils.class :: Dimension mismatch : " + feat1.length + " != " + feat2.length);
	double [] val = new double [feat1.length];
	int i;
	for (i=0;i<feat1.length;i++){
	    val[i] = feat1[i] + feat2[i];
	}
	return val;
    }

    public static double [] times(double [] feat, double v){
	//multiplies feat by v and returns the array

	double [] val = new double [feat.length];
	int i;
	for (i=0;i<feat.length;i++){
	    val[i] = feat[i] * v;
	}
	return val;
    }

    public static void INIT(){
	Calendar cal = Calendar.getInstance();
	
	R = new Random();
	NOW = Algorithm.MONTHS[cal.get(Calendar.MONTH)] + "_" + cal.get(Calendar.DAY_OF_MONTH) + "th__" + cal.get(Calendar.HOUR_OF_DAY) + "h_" + cal.get(Calendar.MINUTE) + "m_" + cal.get(Calendar.SECOND) + "s";
    }
    
    public static double COMPUTE_P(double wp, double wn){
	// first implementation: computes just the result
	double val;

	if (wp + wn > 0.0)
	    val = (wp / (wp + wn));
	else
	    val = 0.5;
	
	if (val != 0.5)
	    return val;

	// p = 0.5: makes a slight random shift to ensure non-zero canonical link
	double vv = RANDOM_P_NOT_HALF();
	
	if (vv < 0.5)
	    val -= EPS2;
	else
	    val += EPS2;
	return val;
    }

    public static double RANDOM_P_NOT_HALF(){
	double vv;
	do{
	    vv = R.nextDouble();
	}while (vv == 0.5);
	return vv;
    }
}
