#!/bin/bash

# Define lists
datasets=("pubmed")
models=("GCN")
split_types=("non-stratified")
inductive_values=("True")
attacks=("EvAttackAccelerated")
train_attack_names=("None")
epsilons=("0.1")
robust_epsilons=("None")
inductive_value="True"
self_training="None"
project_name="Abl_EVA"
robust_training="True"

# Define the missing lists
# n_steps_list=("100" "200" "300" "400" "500" "600" "700" "800")
n_steps_list=("900" "1000" "1100" "1200")

# Mutation-related lists
# mutation_rate_list=("0.005" "0.01" "0.02" "0.05")
mutation_rate_list=("0.005")
# tournament_size_list=("2" "4" "8" "16")
tournament_size_list=("4")
num_population_list=("512" "1024" "2048" "4096" "8192")
# num_cross_over_list=("2" "5" "10" "30")
num_cross_over_list=("10")

mutation_toggle_rate_list=("0.0")
capacity_list=("1024")
# mutation_method_list=("fixed_var" "adaptive" "uniform")
mutation_method_list=("uniform")

#select only one for debugging
# mutation_rate_list=("0.0001")
# tournament_size_list=("2")
# num_population_list=("512")
# num_cross_over_list=("2")
# mutation_toggle_rate_list=("0.0")
# capacity_list=("4096")
# mutation_method_list=("fixed_var")



# Loop over each configuration
for n_steps in "${n_steps_list[@]}"; do
  for mutation_rate in "${mutation_rate_list[@]}"; do
    for tournament_size in "${tournament_size_list[@]}"; do
      for num_population in "${num_population_list[@]}"; do
        for num_cross_over in "${num_cross_over_list[@]}"; do
          for mutation_toggle_rate in "${mutation_toggle_rate_list[@]}"; do
            for capacity in "${capacity_list[@]}"; do
              for mutation_method in "${mutation_method_list[@]}"; do
                    # echo "Running with configuration: n_steps=$n_steps, mutation_rate=$mutation_rate, tournament_size=$tournament_size, num_population=$num_population, num_cross_over=$num_cross_over, mutation_toggle_rate=$mutation_toggle_rate, capacity=$capacity, mutation_method=$mutation_method, radius=$radius, k_hops=$k_hops"
                    attack_configs="{\"n_steps\": $n_steps, \"mutation_rate\": $mutation_rate, \"tournament_size\": $tournament_size, \"num_population\": $num_population, \"num_cross_over\": $num_cross_over, \"mutation_toggle_rate\": $mutation_toggle_rate, \"capacity\": $capacity, \"mutation_method\": \"$mutation_method\", \"mutation_config\": {\"radius\": 0.5}, \"k_hops\": 2}"
                    echo "Attack Configs: $attack_configs"
                    sbatch run_abl_EVA.sbatch "$attack_configs";
               done
            done
          done
        done
      done
    done
  done
  # sleep 20m;
done


#job64 ends