
#script
#!/bin/bash

datasets=("cora" "citeseer" "pubmed");
# datasets=("cora_ml");
models=("GCN" "GAT" "APPNP" "GPRGNN" "ChebNetII");
# models=("SoftMedian_GDC");
split_types=("stratified" "non-stratified")
# split_types=("non-stratified")
inducdtive_values=("True" "False")
attacks=("EvAttackAccelerated" "PRBCD")

epsilons=("0.01" "0.02" "0.05" "0.1" "0.15" "0.2" "0.25")

for dataset_name in "${datasets[@]}"; do
    for model_name in "${models[@]}"; do
        for split_type in "${split_types[@]}"; do
            for epsilon in "${epsilons[@]}"; do
                for attack in "${attacks[@]}"; do
                    echo "Attack: $attack with $model_name and dataset_name=$dataset_name"
                    python3 make_attack.py with training_split_type=$split_type validation_split_type=$split_type n_runs=5 test_split_type=$split_type inductive=$inductive dataset_name=$dataset_name model_name=$model_name wandb_project="AttackingVanillaModel" attack_name=$attack;
                done
            done
        done
    done
done


for model_name in "${models[@]}"; do
    for split_type in "${split_types[@]}"; do
        for inductive in "${inducdtive_values[@]}"; do
            for epsilon in "${epsilons[@]}"; do
                for attack in "${attacks[@]}"; do
                    echo "Attack: $attack with $model_name and dataset_name=cora_ml"
                    python3 make_attack.py with training_split_type=$split_type validation_split_type=$split_type n_runs=5 test_split_type=$split_type inductive=$inductive dataset_name=cora_ml model_name=$model_name wandb_project="AttackingVanillaModel" attack_name=$attack;
                done
            done
        done
    done
done


 

# python3 make_splits.py with training_split_type="non-stratified" validation_split_type="non-stratified" test_split_type="non-stratified" n_runs=10 dataset_name=$dataset_name;
# python3 vanilla_train.py with retrain_models=True save_models=False training_split_type="non-stratified" validation_split_type="non-stratified" test_split_type="non-stratified" n_runs=10 inductive=True dataset_name=$dataset_name model_name="GCN";


# python3 make_splits.py with training_split_type="stratified" validation_split_type="stratified" test_split_type="stratified" n_runs=10 dataset_name=$dataset_name
# python3 vanilla_train.py with retrain_models=True save_models=False training_split_typ./e="stratified" validation_split_type="stratified" test_split_type="stratified" n_runs=10 inductive=True dataset_name=$dataset_name model_name="GCN"

