#script
#!/bin/bash

models=("GPRGNN");
epsilons=("0.1" "0.05");


for model_name in "${models[@]}"; do
    for epsilon in "${epsilons[@]}"; do
            echo "Attack: $attack with $model_name and dataset_name=cora_ml";
            python3 attack_certificate.py with n_runs=5 dataset_name=cora_ml model_name=$model_name wandb_project="AttackingRobustnessCertificate" epsilon=$epsilon p_plus=0.00002 p_minus=0.4 mode="ratio";
            python3 attack_certificate.py with n_runs=5 dataset_name=cora_ml model_name=$model_name wandb_project="AttackingRobustnessCertificate" epsilon=$epsilon p_plus=0.00002 p_minus=0.4 mode="acc";
            python3 attack_certificate.py with n_runs=5 dataset_name=cora_ml model_name=$model_name wandb_project="AttackingRobustnessCertificate" epsilon=$epsilon p_plus=0.001 p_minus=0.6 mode="acc";
    done
done
