# datasets=("cora" "cora_ml" "citeseer" "pubmed");
# models=("GPRGNN");

# datasets=("cora_ml");
datasets=("cora" "cora_ml" "citeseer" "pubmed");
models=("GAT" "APPNP" "GPRGNN" "ChebNetII");
split_types=("non-stratified")
inducdtive_values=("True")

robust_trainings=("True")
self_trainings=("True")
epsilons=("0.1" "0.2")
train_attack_names=("EvAttackAccelerated")



# dataset_name=$1
# model_name=$2
# split_type=$3
# inductive=$4
# robust_training=$5
# train_attack_name=$6
# self_training=$7
# robust_epsilon=$8

for dataset_name in "${datasets[@]}"; do
    for model_name in "${models[@]}"; do
        for split_type in "${split_types[@]}"; do
            for inductive in "${inducdtive_values[@]}"; do
                for robust_training in "${robust_trainings[@]}"; do
                    for train_attack_name in "${train_attack_names[@]}"; do
                        for self_training in "${self_trainings[@]}"; do
                            for robust_epsilon in "${epsilons[@]}"; do
                            echo "Attack: $train_attack_name with $model_name and dataset_name=$dataset_name"
                            sbatch run.sbatch $dataset_name $model_name $split_type $inductive $robust_training $train_attack_name $self_training $robust_epsilon
                            done
                        done
                    done
                done
            done
        done
    done
done