
#script
#!/bin/bash

datasets=("cora" "cora_ml" "citeseer");
# datasets=("cora_ml");
models=("GCN" "GPRGNN");
split_types=("non-stratified")
inducdtive_values=("True")
attacks=("PRBCD" "LRBCD" "EvAttackAccelerated")

epsilons=("0.01" "0.02" "0.05" "0.1" "0.15" "0.2")
# for dataset_name in "${datasets[@]}"; do
for model_name in "${models[@]}"; do
    for split_type in "${split_types[@]}"; do
        for epsilon in "${epsilons[@]}"; do
            for attack in "${attacks[@]}"; do
                echo "Attack: $attack with $model_name and dataset_name=$dataset_name"
                python3 make_attack.py with train_attack_name="EvAttackAccelerated" epsilon=$epsilon training_split_type=$split_type validation_split_type=$split_type n_runs=5 test_split_type=$split_type self_training=True robust_training=True robust_epsilon=0.1 inductive=True device="cuda:0" dataset_name="cora" model_name=$model_name wandb_project="AttackingRobustModel" attack_name=$attack robust_model_flag=True &
                sleep 15; 
                echo "second"
                python3 make_attack.py with train_attack_name="EvAttackAccelerated" epsilon=$epsilon training_split_type=$split_type validation_split_type=$split_type n_runs=5 test_split_type=$split_type self_training=True robust_training=True robust_epsilon=0.1 inductive=True device="cuda:1" dataset_name="cora_ml" model_name=$model_name wandb_project="AttackingRobustModel" attack_name=$attack robust_model_flag=True &
                sleep 15; 
                echo "third"
                python3 make_attack.py with train_attack_name="EvAttackAccelerated" epsilon=$epsilon training_split_type=$split_type validation_split_type=$split_type n_runs=5 test_split_type=$split_type self_training=True robust_training=True robust_epsilon=0.1 inductive=True device="cuda:2" dataset_name="citeseer" model_name=$model_name wandb_project="AttackingRobustModel" attack_name=$attack robust_model_flag=True &
                sleep 15; 
                echo "fourth"
                python3 make_attack.py with train_attack_name="EvAttackAccelerated" epsilon=$epsilon training_split_type=$split_type validation_split_type=$split_type n_runs=5 test_split_type=$split_type self_training=True robust_training=True robust_epsilon=0.1 inductive=True device="cuda:3" dataset_name="pubmed" model_name=$model_name wandb_project="AttackingRobustModel" attack_name=$attack robust_model_flag=True;
            done
        done
    done
done



# for model_name in "${models[@]}"; do
#     for split_type in "${split_types[@]}"; do
#         for inductive in "${inducdtive_values[@]}"; do
#             for epsilon in "${epsilons[@]}"; do
#                 for attack in "${attacks[@]}"; do
#                     echo "Attack: $attack with $model_name and dataset_name=cora_ml"
#                     python3 make_attack.py with training_split_type=$split_type validation_split_type=$split_type n_runs=5 test_split_type=$split_type inductive=$inductive dataset_name=cora_ml model_name=$model_name wandb_project="AttackingVanillaModel" attack_name=$attack;
#                 done
#             done
#         done
#     done
# done