
#script
#!/bin/bash
datasets=("cora_ml")
models=("GCN")

split_types=("non-stratified")
inductive_values=("True")
attacks=("PRBCD" "EvAttackAccelerated")
train_attack_names=("EvAttackAccelerated" "PRBCD" "LRBCD")
epsilons=("0.01" "0.02" "0.04" "0.06" "0.08" "0.1" "0.12" "0.14" "0.16" "0.18" "0.2" "0.22" "0.24" "0.26" "0.28" "0.3")
robust_epsilons=("0.1" "0.2")
inductive_value="True"
self_training="True"
project_name="AblRobustModelAttack"
robust_training="True"

for dataset_name in "${datasets[@]}"; do
    for model_name in "${models[@]}"; do
        for split_type in "${split_types[@]}"; do
            for epsilon in "${epsilons[@]}"; do
                for attack in "${attacks[@]}"; do
                    for train_attack_name in "${train_attack_names[@]}"; do
                        for robust_epsilon in "${robust_epsilons[@]}"; do

                            sbatch run_robust_attack.sbatch  $dataset_name $model_name $split_type $inductive_value $robust_training $train_attack_name $self_training $robust_epsilon $epsilon $attack $project_name

                        done
                    done
                done
            done
        done
    done
done

# datasets=("cora_ml")
# # datasets=("cora_ml");
# # models=("GCN" "GAT" "APPNP" "GPRGNN" "ChebNetII");
# models=("GCN");

# split_types=("non-stratified")
# inducdtive_values=("True")
# attacks=("PRBCD" "EvAttackAccelerated")
# train_attack_names=("EvAttackAccelerated PRBCD LRBCD")
# epsilons=("0.01" "0.02" "0.04" "0.06" "0.08" "0.1" "0.12" "0.14" "0.16" "0.18" "0.2" "0.22" "0.24" "0.26" "0.28" "0.3")
# robust_epsilons=("0.1" "0.2")
# inductive_value="True";
# self_training="True";
# prject_name="AblRobustModelAttack";
# robust_training="True";

# for dataset_name in "${datasets[@]}"; do
# for model_name in "${models[@]}"; do
#     for split_type in "${split_types[@]}"; do
#         for epsilon in "${epsilons[@]}"; do
#             for attack in "${attacks[@]}"; do
#                 for train_attack_name in "${train_attack_names[@]}"; do
#                     for robust_epsilon in "${robust_epsilons[@]}"; do
                    
       
                                    
#                     # dataset_name=$1
#                     # model_name=$2
#                     # split_type=$3
#                     # inductive=$4
#                     # robust_training=$5
#                     # train_attack_name=$6
#                     # self_training=$7
#                     # robust_epsilon=$8
#                     # epsilon=$9
#                     # attack=${10}
#                     # project_name=${11}
#                     # echo "Attack: $attack with $model_name and dataset_name=$dataset_name"
#                     bash test.sh $dataset_name $model_name $split_type $inductive_value $robust_training $train_attack_name $self_training $robust_epsilon $epsilon $attack $project_name
#                     # sbatch run_robust_attack.sbatch $dataset_name $model_name $split_type $inductive_value $robust_training $train_attack_name $self_training $robust_epsilon $epsilon $attack $project_name

#                 done
#                 done
#                done
#             done
#         done
#     done
# done



# for model_name in "${models[@]}"; do
#     for split_type in "${split_types[@]}"; do
#         for inductive in "${inducdtive_values[@]}"; do
#             for epsilon in "${epsilons[@]}"; do
#                 for attack in "${attacks[@]}"; do
#                     echo "Attack: $attack with $model_name and dataset_name=cora_ml"
#                     python3 make_attack.py with training_split_type=$split_type validation_split_type=$split_type n_runs=5 test_split_type=$split_type inductive=$inductive dataset_name=cora_ml model_name=$model_name wandb_project="AttackingVanillaModel" attack_name=$attack;
#                 done
#             done
#         done
#     done
# done