
#script
#!/bin/bash

datasets=("cora" "cora_ml" "citeseer" "pubmed");

# models=("GCN" "GAT" "APPNP" "GPRGNN" "ChebNetII");
models=("GCN" "GPRGNN")
split_types=("non-stratified")
# split_types=("stratified" "non-stratified")

inducdtive_values=("True")
# inducdtive_values=("True" "False")

robust_trainings=("True")
self_trainings=("True")
epsilons=("0.2")
train_attack_names=("PRBCD" "LRBCD" "EvAttackAccelerated")
for dataset_name in "${datasets[@]}"; do
    for model_name in "${models[@]}"; do
        for split_type in "${split_types[@]}"; do
            for inductive in "${inducdtive_values[@]}"; do
                for robust_training in "${robust_trainings[@]}"; do
                    for train_attack_name in "${train_attack_names[@]}"; do
                        for self_training in "${self_trainings[@]}"; do
                            echo "Attack: $train_attack_name with $model_name and dataset_name=$dataset_name"
                            python3 refactor_robust_train.py with retrain_models=False save_models=True training_split_type=$split_type validation_split_type=$split_type n_runs=10 test_split_type=$split_type inductive=$inductive dataset_name=$dataset_name model_name=$model_name wandb_project="TrainingRobustModels" ;
                        done
                    done
                done
            done
        done
    done
done
