
#script
#!/bin/bash

datasets=("cora" "cora_ml" "citeseer" "pubmed");

models=("GCN" "GAT" "APPNP" "GPRGNN" "ChebNetII");

split_types=("stratified" "non-stratified")

inducdtive_values=("True" "False")

for dataset_name in "${datasets[@]}"; do
    for model_name in "${models[@]}"; do
        for split_type in "${split_types[@]}"; do
            for inductive in "${inducdtive_values[@]}"; do
                python3 make_splits.py with training_split_type=$split_type validation_split_type=$split_type test_split_type=$split_type n_runs=10 dataset_name=$dataset_name;
                python3 vanilla_train.py with retrain_models=False save_models=True training_split_type=$split_type validation_split_type=$split_type n_runs=10 test_split_type=$split_type inductive=$inductive dataset_name=$dataset_name model_name=$model_name wandb_project="TrainingVanillaModels";
            done
        done
    done
done