# ART/ARC

This is an implementation of the paper: AutoRegressive Knowledge Base Completion

AutoRegressive Modelling (Convolution, Transformer)  of the joint distribution: p(S,R,O) \\     

ART (transformer) and ARC (convolution) model the factorized joint distribution p(S)p(R|S)p(O|R,S). 

## Installation 

```bash
conda create -n "art" python=3.10
conda activate art
pip install -r requirements.txt
export PYTHONPATH="${PYTHONPATH}:."
```

If you have a GPU:

```bash
export USE_GPU=true
```

## Train your own model

To see all training options run:

```bash
python src/autoregressive_models/train.py --help
```

Then for example run:

```bash
python src/autoregressive_models/train.py --config configs/fb15k237/transformer_one_epoch.yaml
```

This will train the model for one epoch. 

And to evaluate the model:

```bash
python3 experiments/main.py --experiment link-prediction --config ./configs/fb15k237/transformer_one_epoch.yaml
```

If you want to train for more epochs, you can do so by selection another config file.

```bash
python src/autoregressive_models/train.py --config configs/fb15k237/transformer.yaml
```

And to evaluate the model:

```bash
python3 experiments/main.py --experiment link-prediction --config ./configs/fb15k237/transformer.yaml
```

## Reproduce results of the paper 
For instructions on how to reproduce the results from the paper, please see [reproduce.md](reproduce/reproduce.md).



