from experiments.experiment import ExperimentRunner
from experiments.plot import PlotRunner
from src.config import get_cli_args
import torch

def main():
    args = get_cli_args()
    config = vars(args)
    torch.manual_seed(config['seed'])

    if 'plot' in config:
        runner = PlotRunner(config)
        runner.run_plots()
    elif 'experiment' in config:
        runner = ExperimentRunner(config)
        runner.run_experiment()
    else:
        raise ValueError("Neither 'plot' nor 'experiment' specified in config")

if __name__ == '__main__':
    main()
