
# DilateQuant: Accurate and Efficient Diffusion Quantization via Weight Dilation 
## Getting Started

### Installation

Clone this repository, and then create and activate a suitable conda environment named `dilatequant` by using the following command:

```bash
cd DilateQuant
conda env create -f env.yaml
conda activate dilatequant
```

### Usage

1. For Latent Diffusion and Stable Diffusion experiments, first download relevant checkpoints following the instructions in the [latent-diffusion](https://github.com/CompVis/latent-diffusion#model-zoo) and [stable-diffusion](https://github.com/CompVis/stable-diffusion#weights) repos from CompVis. We currently use `sd-v1-4.ckpt` for Stable Diffusion. 

2. Then use the following commands to run:

```bash
# CIFAR-10 (DDIM)
bash scripts/for_cifar.sh

# LSUN Bedroom (LDM-4)
bash scripts/for_bedroom.sh

# LSUN Church (LDM-8)
bash scripts/for_church.sh

# ImageNet (LDM-4)
bash scripts/for_imagenet.sh

# COCO (Stable Diffusion)
bash scripts/for_coco.sh
