import argparse
import os

import json
from tqdm import tqdm
import random
import numpy as np
from PoisonedRAG.src.models import create_model
from PoisonedRAG.src.utils import load_beir_datasets, load_models
from PoisonedRAG.src.utils import save_results, load_json, setup_seeds, clean_str, f1_score
# from PoisonedRAG.src.prompts import wrap_prompt
from main.utils.prompt import wrap_defence_prompt, get_json_response
import torch
import time
def find_same_id_item(items, target_id):
    # get the similar texts to the question with target_id
    for item in items:
        if item.get('id') == target_id:
            return item
    return None

def evaluate(args, llm, db, ans_list, adv_per_query, filename, name):
    all_results = []
    asr_list = []
    ret_list = []
    # to identify which method
    for d in db:
        asr_cnt = 0
        id = d["id"]
        print(id)

        topk_results = d["ctxs"]
        question = d["question"]
        response = d["response"]
        print(id)
        t = find_same_id_item(ans_list, id)
        inco_ans = t["incorrect answer"]
        answer = t["answer"]
        adv_texts = t["adv_texts"]
        assert len(adv_texts) == adv_per_query, f"id:{id} Length of adv_texts ({len(adv_texts)}) does not match adv_per_query ({adv_per_query})"

        # topk_results = sorted(topk_results, key=lambda x: float(x['score']), reverse=True)
        topk_contents = [topk_results[j]["context"] for j in range(args.top_k)]
        # tracking the num of adv_text in topk
        adv_texts = [item["context"] for item in adv_texts]
        adv_text_set = set(adv_texts)

        cnt_from_adv=sum([i in adv_text_set for i in topk_contents])
        query_prompt = wrap_defence_prompt(question, topk_contents)

        # response = llm.query(query_prompt)
        print(question)
        print(f'Output: {response}\n')
        injected_adv=[i for i in topk_contents if i in adv_text_set]
        all_results.append(
            {
                "id": id,
                "question": question,
                f"{name}_injected_adv": injected_adv,
                "top-k": topk_results[:args.top_k],
                "input_prompt": query_prompt,
                "attacked_LLM_output": response,
                f"{name}_target_answer": inco_ans,
                "other_answers(such as ground truth answer)": answer
            }
        )
        if inco_ans != None:
            if clean_str(inco_ans) in clean_str(response):
                asr_cnt += 1
        else:
            if len(injected_adv) > 0:
                if all(clean_str(a) not in clean_str(response) for a in answer):
                    contents = [
                        topk_results[j]["context"] for j in range(args.top_k)
                        if topk_results[j].get("source") != name
                    ]
                    print(len(contents))
                    query_prompt = wrap_defence_prompt(question, contents)
                    original_res = llm.query(query_prompt)
                    rationale, original_response = get_json_response(original_res)
                    if any(clean_str(a) in clean_str(original_response) for a in answer):
                        print("here!is!the!GARAG!")
                        print(answer)
                        print("original:",original_response)
                        print("add garag:", response)
                        asr_cnt += 1

        asr_list.append(asr_cnt)
        ret_list.append(cnt_from_adv)
    save_results(all_results, args.query_results_dir, f'{filename}-{name}')
    print(f'Saving iter results to results/query_results/{args.query_results_dir}/.json')


    asr = np.array(asr_list)
    asr_mean = round(np.mean(asr), 4)
    ret_precision_array = np.array(ret_list) / args.top_k
    ret_precision_mean=round(np.mean(ret_precision_array), 4)
    ret_recall_array = np.array(ret_list) / adv_per_query
    ret_recall_mean=round(np.mean(ret_recall_array), 4)

    ret_f1_array=f1_score(ret_precision_array, ret_recall_array)
    ret_f1_mean=round(np.mean(ret_f1_array), 4)

    print(f"ASR: {asr}")
    print(f"ASR Mean: {asr_mean}\n") 

    print(f"Ret: {ret_list}")
    print(f"Precision mean: {ret_precision_mean}")
    print(f"Recall mean: {ret_recall_mean}")
    print(f"F1 mean: {ret_f1_mean}\n")

    print(f"Ending...")
    return asr_mean, ret_precision_mean, ret_recall_mean, ret_f1_mean