# Copyright 2025 Garena Online Private Limited
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

N_GPU=8
N_SAMPLE=8

python train_zero_math.py \
    --critic_type drgrpo \
    --gpus $N_GPU \
    --enable_prefix_caching \
    --collocate \
    --vllm_sleep \
    --vllm_gpu_ratio 0.35 \
    --gradient-checkpointing \
    --flash-attn \
    --bf16 \
    --rnd-seed \
    --learning_rate 0.000001 \
    --lr_scheduler constant \
    --kl_penalty_coef 0 \
    --num_ppo_epochs 1 \
    --beta 0 \
    --non_stop_fixed_reward 0 \
    --oracle_type reward \
    --oracle math \
    --pretrain lkevinzc/Llama-3.2-3B-NuminaQA \
    --prompt_template r1 \
    --zero-stage 3 \
    --ref_offload \
    --prompt_data ./datasets/train/math_12k \
    --train_split train \
    --input_key problem \
    --output_key answer \
    --max-train 9999999 \
    --num_prompt_epoch 20 \
    --prompt_max_length 1024 \
    --sync_params_every 1 \
    --num_samples $N_SAMPLE \
    --max_step_adjustment 8 \
    --temperature 1 \
    --top_p 1 \
    --generate_max_length 3000 \
    --save_steps -1 \
    --save_from 50 \
    --max_save_num 999999 \
    --max_save_mem 99999999 \
    --train_batch_size 128 \
    --train_batch_size_per_device 1 \
    --rollout_batch_size 128 \
    --rollout_batch_size_per_device $((128 / N_GPU)) \
    --pi_buffer_maxlen_per_device $((128 * N_SAMPLE / N_GPU)) \
    --eval_batch_size 200 \
    --eval_steps 16 \
    --eval_temperature 0 \
    --eval_generate_max_length 3000 \
    --eval_data ./datasets/evaluation_suite \
    --eval_input_key input \
    --use-wb \
    --wb_project oat-zero \
    --wb-run-name llama3.2-3b-drgrpo-r1template
