# Aleatoric Uncertainty for Object Detection

## Stage 1: Obtain Object Features and Uncertainty Scores Based on Foundation Model (SAM)

### Environment Setup
#### (Optional) Create a virtual environment
```bash
conda create -n sam python=3.10
```

#### Install the required packages and download the SAM checkpoint

Please install pytorch and torchvision according to your CUDA version from the [official website](https://pytorch.org/get-started/locally/). 


Install other dependencies and download the SAM checkpoint: 
```bash
pip install opencv-python matplotlib pycocotools
pip install 'git+https://github.com/facebookresearch/segment-anything.git'
wget https://dl.fbaipublicfiles.com/segment_anything/sam_vit_h_4b8939.pth
```

### Obtain Object Features with SAM

Configure the variables in `./sam_feature/scripts/run_features_sam.sh` and run the script to obtain object features. The result would be located in the assigned `MAHA_DIR` variable.

### Obtain Aleatoric Uncertainty Scores

You can get aleatoric uncertainty scores of all training objects via `./sam_feature/cal_data_uncertainty.ipynb`, step by step.

## Stage 2: Running Experiments on YOLOX and DINO

You can run experiments by following the instructions in README in YOLOX and DINO.