import argparse

def parser():
    parser = argparse.ArgumentParser(description='Video Summarization')
    parser.add_argument('--todo', type=str, default='train',
    help='what behavior want to do: train | valid | test | visualize')
    parser.add_argument('--dataset', default='cifar-10', help='use what dataset')
    parser.add_argument('--data_root', default='data/', 
    help='the directory to save the dataset')
    parser.add_argument('--log_root', default='log', 
    help='the directory to save the logs or other imformations (e.g. images)')
    parser.add_argument('--model_root', default='checkpoint', help='the directory to save the models')
    parser.add_argument('--load_checkpoint', default='./model/default/model.pth')
    parser.add_argument('--affix', default='default', help='the affix for the save folder')

# parameters for generating adversarial examples
    parser.add_argument('--epsilon', '-e', type=float, default=0.0157, 
    help='maximum perturbation of adversaries (4/255=0.0157)')
    parser.add_argument('--alpha', '-a', type=float, default=0.00784, 
    help='movement multiplier per iteration when generating adversarial examples (2/255=0.00784)')
    parser.add_argument('--k', '-k', type=int, default=10, 
    help='maximum iteration when generating adversarial examples')

    parser.add_argument('--batch_size', '-b', type=int, default=128, help='batch size')
    parser.add_argument('--max_epoch', '-m_e', type=int, default=200, 
    help='the maximum numbers of the model see a sample')
    parser.add_argument('--learning_rate', '-lr', type=float, default=0.1, help='learning rate')
    parser.add_argument('--momentum', '-m', type=float, default=0.9, help='momentum for optimizer')
    parser.add_argument('--weight_decay', '-w', type=float, default=5e-4, 
    help='the parameter of l2 restriction for weights')

    parser.add_argument('--gpu', '-g', default='0', help='which gpu to use')
    parser.add_argument('--n_eval_step', type=int, default=100, 
    help='number of iteration per one evaluation')
    parser.add_argument('--n_checkpoint_step', type=int, default=4000, 
    help='number of iteration to save a checkpoint')
    parser.add_argument('--n_store_image_step', type=int, default=4000, 
    help='number of iteration to save adversaries')
    parser.add_argument('--perturbation_type', '-p', choices=['linf', 'l2'], default='linf', 
    help='the type of the perturbation (linf or l2)')

    parser.add_argument('--adv_train', action='store_true')

    parser.add_argument('--log_adv', action='store_true')

    parser.add_argument('--poison-rate', type=float, default=0.025)

    parser.add_argument('--trigger', help='Trigger (image size)')

    parser.add_argument('--trigger-alpha')

    parser.add_argument('--y-target', default=2, type=int, help='target Label')

    parser.add_argument('--transparency', default=0.8, type=float, help='(1-Alpha)*Image + Alpha*Trigger')

    parser.add_argument('--figure', default='pr01_fig.png', type=str)

    parser.add_argument('--radius', default=4, type=int)

    parser.add_argument('--use_trigger', default='cube', type=str )

    parser.add_argument('--file_name')

    parser.add_argument('--epoch', default=200, type=int)

    parser.add_argument('--amplitude',  type=float, default=0.0627)

    parser.add_argument('--use_transform', action='store_true')

    parser.add_argument('--divide_epoch', default=30, type=int)

    parser.add_argument('--p_threshold', default=0.1, type=float)

    parser.add_argument('--mean', default=1, type=float)

    parser.add_argument('--local_rank', default=-1, type=int,
                    help='node rank for distributed training')

    parser.add_argument('--second_max_epoch', default=200, type=int)

    parser.add_argument('--time', default=1942, type=int)    

    parser.add_argument('--use_sort', action='store_true')

    parser.add_argument('--use_clean_label', action='store_true')

    parser.add_argument('--victim_model', choices=['vgg', 'resnet'], default='resnet')

    parser.add_argument('--seed', default=10, type=int)

    parser.add_argument('--amp', default=0.0627, type=float)

    parser.add_argument('--pre_epsilon', default=0.031, type=float)

    parser.add_argument('--pre_alpha', default=0.00784, type=float)

    parser.add_argument('--filter_name', default='sds', type=str)

    parser.add_argument('--model_name', default='sds', type=str)


    return parser.parse_args()

def print_args(args, logger=None):
    for k, v in vars(args).items():
        if logger is not None:
            logger.info('{:<16} : {}'.format(k, v))
        else:
            print('{:<16} : {}'.format(k, v))