import argparse
import logging
import os
import torch
from model_transformer.exp.exp_Xer_main import Exp_Main
import random
import numpy as np
import setproctitle
import sys
from datetime import datetime




if __name__ == '__main__':
    setproctitle.setproctitle('LYX_thread')

    current_time = datetime.now()
    formatted_time = current_time.strftime("%Y-%m-%d %H:%M:%S")
    print("Task start:", formatted_time)
    parser = argparse.ArgumentParser(description='Non-stationary Transformers for Time Series Forecasting')


    # basic config
    parser.add_argument('--is_training', type=bool, default=True, help='status')
    parser.add_argument('--model_id', type=str, default='PJM', help='model id')
    parser.add_argument('--model', type=str, default='test',
                        help='')

    # data loader
    parser.add_argument('--data', type=str, default='custom', help='dataset type')
    #parser.add_argument('--root_path', type=str, default='./dataset/ETT-small/', help='root path of the data file')
    #parser.add_argument('--data_path', type=str, default='ETTh2.csv', help='data file')
    parser.add_argument('--features', type=str, default='MS',
                        help='forecasting task, options:[M, S, MS]; M:multivariate predict multivariate, S:univariate predict univariate, MS:multivariate predict univariate')
    parser.add_argument('--target', type=str, default='OT', help='target feature in S or MS task')
    parser.add_argument('--freq', type=str, default='h',
                        help='freq for time features encoding, options:[s:secondly, t:minutely, h:hourly, d:daily, b:business days, w:weekly, m:monthly], you can also use more detailed freq like 15min or 3h')
    parser.add_argument('--checkpoints', type=str, default='./checkpoints/', help='location of model checkpoints')

    # forecasting task

    # model define
    #parser.add_argument('--enc_diff_in', type=int, default=3, help='encoder input size')
    parser.add_argument('--enc_in', type=int, default=3, help='encoder input size')
    parser.add_argument('--dec_in', type=int, default=1, help='decoder input size')
    parser.add_argument('--c_out', type=int, default=3, help='output size')
    parser.add_argument('--diff_in', type=int, default=1, help='output size in Xer diff')
    parser.add_argument('--c_out_diff', type=int, default=1, help='output size in Xer diff')
    parser.add_argument('--d_model', type=int, default=512, help='dimension of model')
    parser.add_argument('--n_heads', type=int, default=8, help='num of heads')
    parser.add_argument('--e_layers', type=int, default=3, help='num of encoder layers')
    parser.add_argument('--d_layers', type=int, default=1, help='num of decoder layers')
    parser.add_argument('--d_ff', type=int, default=2048, help='dimension of fcn')
    parser.add_argument('--diff_dim', type=int, default=128)
    parser.add_argument('--factor', type=int, default=3, help='attn factor')
    parser.add_argument('--distil', action='store_false',
                        help='whether to use distilling in encoder, using this argument means not using distilling',
                        default=True)
    parser.add_argument('--dropout', type=float, default=0.1, help='dropout')
    parser.add_argument('--embed', type=str, default='timeF',
                        help='time features encoding, options:[timeF, fixed, learned]')
    parser.add_argument('--activation', type=str, default='gelu', help='activation')
    parser.add_argument('--output_attention', action='store_true', help='whether to output attention in encoder')
    parser.add_argument('--do_predict', action='store_true', help='whether to predict unseen future data')

    parser.add_argument('--k_z', type=float, default=1e-2, help='KL weight 1e-9')
    parser.add_argument('--k_cond', type=float, default=1, help='Condition weight')
    parser.add_argument('--d_z', type=int, default=8, help='KL weight')


    # optimization
    parser.add_argument('--num_workers', type=int, default=4, help='data loader num workers')
    parser.add_argument('--itr', type=int, default=1, help='experiments times')
    parser.add_argument('--train_epochs', type=int, default=200, help='train epochs')
    parser.add_argument('--batch_size', type=int, default=128, help='batch size of train input data')  # 32
    parser.add_argument('--test_batch_size', type=int, default=32, help='batch size of train input data')  # 32
    parser.add_argument('--patience', type=int, default=10, help='early stopping patience')
    parser.add_argument('--learning_rate', type=float, default=0.0001, help='optimizer learning rate for diffusion model')
    parser.add_argument('--learning_rate_Cond', type=float, default=0.0001, help='optimizer learning rate')
    parser.add_argument('--des', type=str, default='Exp', help='exp description')
    parser.add_argument('--loss', type=str, default='mse', help='loss function')
    parser.add_argument('--lradj', type=str, default='type2', help='adjust learning rate')
    parser.add_argument('--use_amp', action='store_true', help='use automatic mixed precision training', default=False)

    # GPU
    parser.add_argument('--use_gpu', type=bool, default=True, help='use gpu')
    parser.add_argument('--gpu', type=int, default=0, help='gpu')
    parser.add_argument('--use_multi_gpu', type=bool, default=False, help='use multiple gpus')
    parser.add_argument('--devices', type=str, default='0,1,2,3', help='device ids of multile gpus')
    parser.add_argument('--seed', type=int, default=1, help='random seed')


    # CART related args
    parser.add_argument('--diffusion_config_dir', type=str, default='./model9_NS_transformer/configs/toy_8gauss.yml',
                        help='')

    # parser.add_argument('--cond_pred_model_dir', type=str,
    #                     default='./checkpoints/cond_pred_model_pertrain_NS_Transformer/checkpoint.pth', help='')
    parser.add_argument('--cond_pred_model_pertrain_dir', type=str,
                        default='./checkpoints/cond_pred_model_pertrain_NS_Transformer/checkpoint.pth', help='')

    parser.add_argument('--CART_input_x_embed_dim', type=int, default=32, help='feature dim for x in diffusion model')
    parser.add_argument('--mse_timestep', type=int, default=0, help='')

    parser.add_argument('--MLP_diffusion_net', type=bool, default=False, help='use MLP or Unet')

    # Some args for Ax (all about diffusion part)
    parser.add_argument('--timesteps', type=int, default=1000, help='')

    parser.add_argument('--dataset', type=str, default='EPF', help="Dataset to load. Available: physionet, mimic, ushcn")
    parser.add_argument("--root_path", default="dataset/EPF")
    parser.add_argument("--data_path", default="PJM.csv")
    
    parser.add_argument('--seq_len', type=int, default=24*8, help="number of hours (months for ushcn and ms for activity) as historical window")
    parser.add_argument("--pred_window", type=int, default=24*1, help="predict length")
    parser.add_argument("--label_len", type=int, default=24*0, help="predict length")
    parser.add_argument("--pseudo_len", type=int, default=24,)

    parser.add_argument("--augmentation_ratio", default=0, type=int)
    parser.add_argument("--patch_len", default=24, type=int)
    parser.add_argument("--use_norm", type=bool, default=True)

    parser.add_argument("--mask_target_ratio", type=float, default=0.)
    parser.add_argument("--mask_covar_ratio", type=float, default=0.)
    parser.add_argument("--downsample", type=float, default=0)
    parser.add_argument("--timeenc", type=int, default=0)
    parser.add_argument('--block_miss', type=int, default=0)

    args = parser.parse_args()

    args.model_id = f'{args.model_id}_{str(args.seq_len)}_{str(args.pred_window)}'  
    args.use_gpu = True if torch.cuda.is_available() and args.use_gpu else False
    args.history = args.seq_len
    args.pred_len = args.pred_window
    if args.seed == -1:
        fix_seed = np.random.randint(2147483647)
    else:
        fix_seed = args.seed

    print('Using seed:', fix_seed)
    def set_all_seed(seed):
        torch.manual_seed(seed)
        torch.cuda.manual_seed_all(seed)
        torch.cuda.manual_seed(seed)
        torch.backends.cudnn.deterministic = True
        np.random.seed(seed)
        random.seed(seed)
    set_all_seed(fix_seed)

    if args.use_gpu:
        if args.use_multi_gpu:
            args.devices = args.devices.replace(' ', '')
            device_ids = args.devices.split(',')
            args.device_ids = [int(id_) for id_ in device_ids]
            args.gpu = args.device_ids[0]
        else:
            torch.cuda.set_device(args.gpu)

    print('Args in experiment:')
    print(args)

    Exp = Exp_Main
    setting = '{}_{}_{}_ft{}_sl{}_ll{}_pl{}_dm{}_nh{}_el{}_dl{}_df{}_fc{}_eb{}_dt{}_{}_seed{}_RM{}_BM{}.log'.format(
                args.model_id,
                args.model,
                args.data,
                args.features,
                args.seq_len,
                args.label_len,
                args.pred_window,
                args.d_model,
                args.n_heads,
                args.e_layers,
                args.d_layers,
                args.d_ff,
                args.factor,
                args.embed,
                args.distil,
                args.des,
                args.seed,
                args.mask_target_ratio,
                args.block_miss,)
    os.makedirs( os.path.join("log", args.model, args.data_path), exist_ok=True)
    log_path = os.path.join("log", args.model, args.data_path, setting)
    

    logging.basicConfig(
        level=logging.INFO,
        format='%(asctime)s - %(levelname)s - %(message)s',
        handlers=[
            logging.FileHandler(log_path),  # 日志输出到文件
            logging.StreamHandler(sys.stdout)     # 同时输出到控制台
        ]
    )
    logger = logging.getLogger(__name__)
    if args.is_training:
        # 配置日志
    
        for ii in range(args.itr):
            # setting record of experiments
            setting = '{}_{}_{}_ft{}_sl{}_ll{}_pl{}_dm{}_nh{}_el{}_dl{}_df{}_fc{}_eb{}_dt{}_{}_seed{}_{}'.format(
                args.model_id,
                args.model,
                args.data,
                args.features,
                args.seq_len,
                args.label_len,
                args.pred_window,
                args.d_model,
                args.n_heads,
                args.e_layers,
                args.d_layers,
                args.d_ff,
                args.factor,
                args.embed,
                args.distil,
                args.des, 
                args.seed,ii)


            exp = Exp(args)  # set experiments
            exp.set_logger(logger)
            logger.info('>>>>>>>start training : {}>>>>>>>>>>>>>>>>>>>>>>>>>>'.format(setting))
            exp.train(setting)
            #exp.train_cond(setting)

            logger.info('>>>>>>>testing : {}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<'.format(setting))
           
            exp.test_cond(setting, True)
            exp.test(setting, test=1)

            current_time = datetime.now()
            formatted_time = current_time.strftime("%Y-%m-%d %H:%M:%S")
            logger.info(f"Time Train finished: {formatted_time}" )

            torch.cuda.empty_cache()
    
