# %% import
import numpy as np
import pandas as pd
from matplotlib import pyplot as plt
import seaborn as sns

plt.rc("text", usetex=True)

sns.set(
    style="white",
    font_scale=1.2,
    rc={"lines.linewidth": 2, "figure.figsize": (5, 2.5)},
)

# %% --> UB
with open("creditscore_UB.csv", "r") as f:
    df_diff_upperbound = pd.read_csv(f, index_col=False)

# fig, ax = plt.subplots()
graph = sns.lineplot(data=df_diff_upperbound, x="K", y="Diff", color="k")
graph = sns.lineplot(data=df_diff_upperbound, x="K", y="UB", color="r")
graph.legend(["Diff", "UB"], framealpha=0.5, prop={"size": 11})
graph.set_xlabel(r"$K$")
graph.set_ylabel(r"Value")
plt.yscale("log")
plt.savefig("exp_UB.pdf", bbox_inches="tight")


# %% --> LB
with open("creditscore_LB.csv", "r") as f:
    df_diff_lowerbound = pd.read_csv(f, index_col=False)

# fig, ax = plt.subplots()
graph = sns.lineplot(data=df_diff_lowerbound, x="K", y="Max", color="k")
graph = sns.lineplot(data=df_diff_lowerbound, x="K", y="LB", color="r")
graph.legend(["Max", "LB"], framealpha=0.5, prop={"size": 11})
graph.set_xlabel(r"$K$")
graph.set_ylabel(r"Value")
plt.yscale("log")
plt.savefig("exp_LB.pdf", bbox_inches="tight")


# %%
