import argparse


def args_setup():
    parser = argparse.ArgumentParser()
    # Name
    parser.add_argument(
        "--name", type=str, default="dpa_lora", help="name of the experiment"
    )
    parser.add_argument(
        "--aggregation_method",
        default="fedmuscle",
        type=str,
        choices=[
            "fedmuscle",
        ],
    )
    parser.add_argument(
        "--adapter_method",
        type=str,
        default="lora",
        choices=[
            "lora",
        ],
    )

    # LoRA
    parser.add_argument("--rank", type=int, default=16, help="LoRA rank")

    parser.add_argument(
        "--proj_dim",
        type=int,
        default="256",
        help="specify the projection model output dimension",
    )

    # CL temperature
    parser.add_argument(
        "--tau",
        type=float,
        default=0.2,
        help="value of temperature in tau^M+1 in Muscle loss",
    )

    parser.add_argument(
        "--tau_prime",
        type=float,
        default=0.15,
        help="value of temperature in tau^M in Muscle loss",
    )

    # Device and seed
    parser.add_argument("--device", type=int, default=0, help="gpu device id")
    parser.add_argument("--seed", type=int, default=1, help="seed")

    # Dataset
    parser.add_argument(
        "--public_dataset_name",
        type=str,
        default="pascal",
        help="specify the dataset",
        choices=[
            "CIFAR10",
            "CIFAR100",
            "coco",
            "pascal",
            "flicker_multi_modal",
        ],
    )
    parser.add_argument(
        "--data_dir",
        default="/path/to/clients/data/",
        type=str,
        required=False,
        help="specify the data direction",
    )
    parser.add_argument(
        "--root_train_image_folder",
        default="/path/to/train/image/folder/",
        type=str,
        required=False,
        help="specify the data folder containing all the training images",
    )
    parser.add_argument(
        "--root_val_image_folder",
        default="/path/to/val/image/folder/",
        type=str,
        required=False,
        help="specify the data folder containing all the validation images",
    )
    parser.add_argument(
        "--models_path",
        type=str,
        required=False,
        default="/path/to/models",
        help="specify the base path of the huggingface models",
    )
    # Clients
    parser.add_argument(
        "--num_MLC_clients",
        type=int,
        default=3,
        help="number of clients with multi-lable classification task",
    )
    parser.add_argument(
        "--num_IC100_clients",
        type=int,
        default=2,
        help="number of clients with CIFAR100 image classification task",
    )
    parser.add_argument(
        "--num_IC10_clients",
        type=int,
        default=1,
        help="number of clients with CIFAR10 image classification task",
    )
    parser.add_argument(
        "--num_semantic_segmentation_clients",
        type=int,
        default=0,
        help="number of clients with coco semantic segmentation task",
    )
    parser.add_argument(
        "--num_yahoo_topic_classification_clients",
        type=int,
        default=0,
        help="number of clients with yahoo topic classification task",
    )
    # Training
    parser.add_argument(
        "--num_epochs", type=int, default=150, help="total number of epochs"
    )
    parser.add_argument(
        "--num_cl_epochs", type=int, default=1, help="total number of contrastive epochs"
    )
    parser.add_argument(
        "--post_training",
        type=int,
        default=10,
        help="total number of local training after iterations",
    )

    parser.add_argument("--sel_rep_num", type=int, default=3, help="Maximum number of selected representations to be used in Muscle loss for each client")

    parser.add_argument("--batch_size", type=int, default=32, help="batch size")

    parser.add_argument("--pub_batch_size", type=int, default=32, help="batch size of public data")

    parser.add_argument("--lr", type=float, default=0.001, help="learning rate")
    # Logging
    parser.add_argument(
        "--log_interval",
        type=int,
        default=1,
        help="intervals of logging valication accuracy",
    )

    args = parser.parse_args()
    return args
