import numpy as np
from sklearn.datasets import make_spd_matrix


def cov_to_corr(mat):
    D = np.sqrt(np.diag(np.diag(mat)))
    Dinv = np.linalg.inv(D)
    corr_mat = Dinv @ mat @ Dinv
    return corr_mat


def sample_corrmat(n_feats, cond_low, cond_high):
    n_tries = 0
    cond = -1
    while cond < cond_low or cond > cond_high:
        if n_tries > 10000:
            print('failed to find covariance mat')
            break
        Q = make_spd_matrix(n_feats)
        Q = cov_to_corr(Q)
        cond = np.linalg.cond(Q)
        n_tries += 1
    print('tries: ', n_tries)
    return Q


def gen_condition_corrmat(n_feats, condition='low'):
    if condition == 'low':
        corr = np.eye(n_feats)
    elif condition == 'med':
        cond_limit = (1, 100)
        corr = sample_corrmat(n_feats, *cond_limit)
    elif condition == 'high':
        cond_limit = (250, 500)
        corr = sample_corrmat(n_feats, *cond_limit)
    return corr
