import numpy as np
from sklearn.datasets import make_spd_matrix


def generate_mixture(N, n_clusters, n_dim=10, family='gaussian'):
    rng = np.random.default_rng(seed=0)

    class_idx = rng.choice(n_clusters, replace=True, size=N)

    if family == 'gaussian':
        mus = rng.uniform(low=-4.0, high=4.0, size=(n_clusters, n_dim))
        sigmas = [1.0 * make_spd_matrix(n_dim, random_state=0) + \
            5.0 * np.eye(n_dim) for _ in range(n_clusters)]

        X = np.zeros((N, n_dim))
        for i in range(N):
            x_sample = rng.multivariate_normal(mus[class_idx[i]], sigmas[class_idx[i]])
            X[i] = x_sample

    elif family == 'multinomial':
        total_counts = 100
        p_vecs = rng.dirichlet(np.ones(n_dim) * 10, size=n_clusters)

        X = np.zeros((N, n_dim))
        for i in range(N):
            x_sample = rng.multinomial(total_counts, p_vecs[class_idx[i]])
            X[i] = x_sample

    elif family == 'exponential':
        lambdas = rng.uniform(0.1, 10, size=(n_clusters, n_dim))

        X = np.zeros((N, n_dim))
        for i in range(N):
            x_sample = np.zeros(n_dim)
            for j in range(n_dim):
                x_sample[j] = rng.exponential(lambdas[class_idx[i], j])
            X[i] = x_sample
        
    return X, class_idx
