#!/bin/bash

# For reasoning_retrieval task, focus on degree = 1,
# i.e. chain of needles, for simplification

# solve_method: directly / decomposition_cyclic / decomposition_parallel
# prompt_option: answer_directly / reason_step_by_step
# llm_model: llama3_70b / qwen2_72b


# --- compare prompt_option, vary degree (g) ---
for OPTION in answer_directly reason_step_by_step
do
    timestamp=$(date "+%y-%m-%d-%H-%M-%S")
    python3 run_exp_single_variable.py \
        --task reasoning_retrieval \
        --llm_model qwen2_72b \
        --m_base 50 \
        --variable_name degree \
        --lst_variable 2 3 4 5 6 7 \
        --depth 2 \
        --width 300 \
        --save_results True \
        --ntrials 10 \
        --base_seed 2001 \
        --solve_method decomposition_parallel \
        --prompt_option ${OPTION} \
        |& tee log/exp/log_${timestamp}.log
done


# --- compare solve_method, vary depth (d) ---
for METHOD in decomposition_cyclic decomposition_parallel
do
    timestamp=$(date "+%y-%m-%d-%H-%M-%S")
    python3 run_exp_single_variable.py \
        --task reasoning_retrieval \
        --llm_model qwen2_72b \
        --m_base 100 \
        --variable_name depth \
        --lst_variable 2 3 4 5 6 7 \
        --width 100 \
        --degree 1 \
        --save_results True \
        --ntrials 10 \
        --base_seed 2001 \
        --solve_method ${METHOD} \
        --prompt_option reason_step_by_step \
        |& tee log/exp/log_${timestamp}.log
done

# --- compare solve_method, vary width (w) ---
for METHOD in decomposition_cyclic decomposition_parallel
do
    timestamp=$(date "+%y-%m-%d-%H-%M-%S")
    python3 run_exp_single_variable.py \
        --task reasoning_retrieval \
        --llm_model qwen2_72b \
        --m_base 100 \
        --variable_name width \
        --lst_variable 50 100 150 200 250 300 \
        --depth 5 \
        --degree 1 \
        --save_results True \
        --ntrials 10 \
        --base_seed 2001 \
        --solve_method ${METHOD} \
        --prompt_option reason_step_by_step \
        |& tee log/exp/log_${timestamp}.log
done

