# LLM-based algorithms


## Usage

### Run experiments

To run experiments for a certain task:

```bash
bash ./scripts/exp_{task}.sh
```

or copy a piece of scripts therein, modify the parameters, and run it in the terminal, for example:

```bash
python3 run_exp_single_variable.py \
    --task counting \
    --llm_model ollama_llama3_8b \
    --variable_name n \
    --lst_variable 200 150 100 50 20 10 \
    --n_base 200 \
    --save_results True \
    --ntrials 10
```

Parameters:

- `task`: name of the task, {"counting", "sorting", "retrieval", "retrieval_no_needle", "rag", "reasoning_retrieval", "reasoning_DAG"}.
- `llm_model`: name of the LLM model, i.e. `config_name` in `model_configs.json`.
- `variable_name`: "n" for problem size, "m" for sub-task size, or other variables
- `lst_variable`: list of values for the variable.
- `n_base`: the maximum of `lst_variable` (if `variable_name` is "n"), or the value of "n" (if `variable_name` is "m").
- `save_results`: if `True`, experiment results will be saved to `./out`
- `ntrials`: number of independent trials for each experiment config, i.e. each entry of `lst_variable`.

### Plot results

To plot experiment results that have been saved:

```bash
bash ./scripts/plot_{task}.sh
```

or copy a piece of scripts therein and run it in the terminal, for example:

```bash
python3 plot_exp_results.py \
    --folder ./out/counting/{path-to-exp-result}
```

The path to the experiment results need to be replaced with the actual one generated during your own experiment.
The generated figures will be saved to the same folder.

## Tested Models

The following models have been tested:
GPT-4 Turbo,
GPT-3.5 Turbo,
Llama3-8B (with ollama),
Llama3-70B (with vLLM),
Qwen2-72B (with vLLM).
