#!/bin/bash

# solve_method: "step_by_step" (single LLM call) / "recursively"
# prompt_option: "answer_directly" / "reason_step_by_step"
# llm_model: llama3_70b / qwen2_72b


# --- compare prompt_option, vary degree (g) ---
for OPTION in answer_directly reason_step_by_step
do
    timestamp=$(date "+%y-%m-%d-%H-%M-%S")
    python3 run_exp_single_variable.py \
        --task reasoning_DAG \
        --llm_model qwen2_72b \
        --variable_name degree \
        --lst_variable 8 7 6 5 4 3 2 \
        --depth 3 \
        --width 100 \
        --save_results True \
        --ntrials 10 \
        --base_seed 2001 \
        --solve_method recursively \
        --prompt_option ${OPTION} \
        |& tee log/exp/log_${timestamp}.log
done


# --- compare prompt_option, vary depth (d) ---
for OPTION in answer_directly reason_step_by_step
do
    timestamp=$(date "+%y-%m-%d-%H-%M-%S")
    python3 run_exp_single_variable.py \
        --task reasoning_DAG \
        --llm_model qwen2_72b \
        --variable_name depth \
        --lst_variable 9 8 7 6 5 4 3 2 \
        --degree 4 \
        --width 6 \
        --save_results True \
        --ntrials 10 \
        --base_seed 2001 \
        --solve_method recursively \
        --prompt_option ${OPTION} \
        |& tee log/exp/log_${timestamp}.log
done
